$(function () {
    var zindex = 10,
            dropped = 0,
            elements = [
                [4, 40],
                [4, 30],
                [5, 20],
                [1,15],
                [1,25]
            ],
            shapes = [
                [3, 30, 0],
                [4, 40, 0],
                [5, 20, 0]
            ],
            deg = [0, -60, 60, 90, 90, 0, 0, 0, 110, 71, 324, 38],
            korTop = [0, 53, 53, 90, 90, 0, 0, 0, 32, 32, 23, 23],
            korLeft = [-8, -23, -34, -100, -100, 0, 0, -10, -26, -30, -6, -12],
            drop = function (event, ui) {
                if ($(this).data('value') === ui.draggable.data('value')) {
                    var id = $(this).attr('id');
                    var type = $(this).data('type');
                    var no = id.replace('drop', '');
                    var top = $(this).position().top + korTop[no];
                    var left = $(this).position().left + korLeft[no];
                    $(this).data('value', 0);
                    ui.draggable
                            .draggable({revert: false})
                            .draggable("option", "disabled", true);
                    ui.draggable
                            .rotate({animateTo: deg[no], duration: 2500});
                    ui.draggable
                            .animate({top: top, left: left});
                    
                    shapes[type][2]++;
                    console.log(shapes);
                    if (shapes[type][2] === shapes[type][0]) {
                        $('#jplayer_well').jPlayer('play');
                    }
                } else {
                    $('#jplayer_wrong').jPlayer('play');
                }

            };

    for (var i = 0, k = 0; i < elements.length; i++) {
        for (var j = 0; j < elements[i][0]; j++) {
            $('main').append(
                    '<div id="drag' + k +
                    '" class="dragg" data-value="' + elements[i][1] +
                    '">' + elements[i][1] + ' mm</div>'
                    );
            k++;
        }
    }

    for (var i = 0, k = 0; i < shapes.length; i++) {
        for (var j = 0; j < shapes[i][0]; j++) {
            $('main').append(
                    '<div id="drop' + k +
                    '" class="dropp" data-type="' + i +
                    '" data-value="' + shapes[i][1] +
                    '"><div></div></div>'
                    );
            k++;
        }
    }

    $(".dragg")
            .draggable({
                start: function () {
                    zindex++;
                    $(this).css('z-index', zindex);
                },
                revert: true,
                revertDuration: 400
            });

    $(".dropp").droppable({
        accept: ".dragg",
        tolerance: "pointer",
        hoverClass: "ui-state-hover",
        disabled: false,
        drop: drop
    });

});
