$(function ()
{
    var count = 0,
            zindex = 10,
            figures = ['triangle', 'hexagon', 'pentagon', 'square', 'rectangle', 'circle'],
            dropIds=[6,1,4,5,3,2],
            dropNames=['koło','trójkąt','kwadrat','prostokąt','pięciokąt','sześciokąt'],
            drop = function (event, ui) {
                if ($(this).data('id') === ui.draggable.data('id')) {
                    var id = $(this).data('id');
                    $(this).fadeOut();
                    ui.draggable.fadeOut();
                    var position = $('.el-elem_' + id + '_left').position();
                    $('.dandd2').append('<div data-value="'+id+'" class="figure el-' + figures[id - 1] + '" style="left:' + position.left + 'px;top:' + position.top + 'px;"></div>');
                    $('.el-' + figures[id - 1]).fadeIn(500).draggable({
                        start: function () {
                            zindex++;
                            $(this).css('z-index', zindex);
                        },
                        revert: true,
                        revertDuration: 900
                    });
                }
            },
            dropFigure = function (event, ui) {
                if (ui.draggable.data('value') === $(this).data('value')) {
                    var top = $(this).position().top+($(this).height()-ui.draggable.height())/2;
                    var left = $(this).position().left+($(this).width()-ui.draggable.width())/2;
                    count++;
                    ui.draggable
                            .addClass('color')
                            .draggable({revert: false})
                            .draggable("option", "disabled", true);
                    ui.draggable.animate({
                        top: top,
                        left: left
                    }, 900);
                    if(count === 6){
                        $('.dandd2').animate({top:-200});
                        $('#jplayer_well').jPlayer('play');
                    }
                } else {
                    $('#jplayer_wrong').jPlayer('play');
                }
            };

    for (var i = 1; i <= 6; i++) {
        $('.dandd').append('<i class="el el-elem_' + i + '_left" data-id="' + i + '"></i>');
        $('.dandd').append('<i class="el el-elem_' + i + '_right" data-id="' + i + '"></i>');
        $('.dandd2').append('<div class="dropFigure" data-value="'+dropIds[i-1]+'" style="top:432px;left:'+(-113+156*i)+'px">'+dropNames[i-1]+'</div>');
    }

    $(".el").draggable({
        start: function () {
            zindex++;
            $(this).css('z-index', zindex);
        },
        revert: true,
        revertDuration: 900
    });

    $(".el").droppable({
        drop: drop,
                tolerance: "touch"
    });
    
    $(".dropFigure").droppable({
        accept: ".figure",
        drop: dropFigure
    });
});