
$(function () {

    var clouds = [15, 24, 25, 18, 36, 64, 70],
            mixClouds = shuffleArray(clouds),
            posClouds = [
                [100, 170],
                [728, 33],
                [666, 168],
                [404, 188],
                [530, 39],
                [0, 50],
                [206, 42]
            ],
            tab = [
                [3, 2, 4],
                [1, 3, 6],
                [2, 4, 8],
                [1, 5, 5],
                [2, 3, 6]
            ],
            mixTour = shuffleArray(tab),
            distance = 160,
            speed = 100,
            tour = 0,
            click = function () {
                var tourValue = mixTour[tour][0] * mixTour[tour][1] * mixTour[tour][2];
                var $this = $(this);
                console.log($this.data('value') + "|" + tourValue);
                if ($this.data('value') !== tourValue) {
                    $('#jplayer_wrong').jPlayer('play');
                    $this.html('<div class="l821-bad l821"></div>');
                    setTimeout(function () {
                        $this.html($this.data('value'));
                    }, 800);
                } else {
                    $('#jplayer_well').jPlayer('play');
                    $this.html('<div class="l821-ok l821"></div>');
                    $this.parent().addClass('ok');
                    $this.unbind('click');
                    tour++;
                    if (tour < tab.length) {
                        fillTab(tour);
                    } else {
                        var txt = 'Brawo';
                        $('.cloud').unbind('click');
                        $('.cloud:not(.ok)').fadeOut(0);
                        $('.tab').addClass('end');
                        $('.tab0').text(txt);
                        $('.tab1').text(txt);
                        $('.tab2').text(txt);
                    }
                }
            };

    function shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    function cloudToRight(el) {
        var $this = $('.cloud' + el);
        var dist = $this.position().left + distance;
        $this.animate({left: dist}, (speed * clouds[el]), function () {
            cloudToLeft(el);
        });
    }
    
    function cloudToLeft(el) {
        var $this = $('.cloud' + el);
        var dist = $this.position().left - distance;
        $this.animate({left: dist}, (speed * clouds[el]), function () {
            cloudToRight(el);
        });
    }
    
    function fillTab(t) {
        var mixTab = shuffleArray(mixTour[t]);
        $('.tab0').text(mixTab[0]);
        $('.tab1').text(mixTab[1]);
        $('.tab2').text(mixTab[2]);
    }

    for (var i = 0; i < mixClouds.length; i++) {
        $('main').append('<div class="cloud' + i +
                ' cloud" style="left:' + posClouds[i][0] +
                'px;top:' + posClouds[i][1] +
                'px"><div class="l821 l821-ch' + i +
                '" data-value="' + mixClouds[i] +
                '">' + mixClouds[i] +
                '</div></div>');
        cloudToRight(i);
    }

    for (var i = 0; i < 3; i++) {
        $('main').append('<div class="tab' + i +
                ' tab" data-value="0"></div>');
    }

    $('.l821').click(click);

    fillTab(tour);

});
