
$(function () {

    var data = [
        [234, 187, 1, 4, 2, 1],
        [563, 274, 0, 2, 8, 9],
        [389, 122, 1, 5, 1, 1],
        [950, 848, 0, 1, 0, 2],
        [177, 725, 1, 9, 0, 2]
    ],
            mix,
            task,
            digit,
            click = function () {
                $('.digit' + digit)
                        .data('value', $(this).data('value'))
                        .text($(this).data('value'));
                if (digit === 2) {
                    digit = 0;
                    check();
                } else {
                    digit++;
                }
            },
            reset = function () {
                task = 0;
                digit = 0;
                clearResult();
                mix = shuffleArray(data);
                fillData(task);
                $('.dig').unbind('click');
                $('.dig').click(click);
                $('.controler').animate({top: 195}, 1500, function () {
                    $('.content').fadeIn(800);
                });
            };

    function shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    function fillData(task) {
        var znak = (mix[task][2] === 0) ? "&minus;" : "+";
        $('.content').animate({opacity: 0}, 300, function () {
            clearResult();
            $('.line1').html(mix[task][0]);
            $('.line2').html(znak + mix[task][1]);
            $('.content').animate({opacity: 1}, 300);
        });
    }
    function clearResult() {
        $('.result').children()
                .data('value', null)
                .text('');
    }
    function check() {
        if ($('.digit0').data('value') === mix[task][5] &&
                $('.digit1').data('value') === mix[task][4] &&
                $('.digit2').data('value') === mix[task][3]) {
            task++;
            $('#jplayer_well').jPlayer('play');
            $('#jplayer_well').on($.jPlayer.event.ended, function (event) {
                if (task < data.length) {
                    fillData(task);
                } else {
                    $('.content').text('BRAWO');
                    $('.controler').animate({top: 915}, 1500);
                    $('.dig').unbind('click');
                }
            });
        } else {
            $('#jplayer_wrong').jPlayer('play');
                        $('#jplayer_wrong').on($.jPlayer.event.ended, function (event) {
                            clearResult();
                        });
        }
    }

    for (var i = 0; i <= 9; i++) {
        var val = (i === 9) ? 0 : i + 1;
        $('.keypad').append('<div class="btn dig" data-value="' + val +
                '">' + val +
                '</div>');
    }

    $('.out').click(reset);

    reset();

});
