<?php
	require_once('./lib/hzip.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=6');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip'); 
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=6&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=6');
			exit();
		}
	}
	
	/*
	 * Some variables.
	 */
	mb_internal_encoding("UTF-8");
	$password = mb_strtoupper($_POST['gamePassword']);
	$words = array();
	$questions = htmlspecialchars($_POST['gameQuestions'], ENT_NOQUOTES);
	$answers = mb_strlen($password);
	$pass_len = mb_strlen($password);
	$letter_cnt = 0;
	
	$crossword_string = '';
	$answernum_string = '';
	
	/*
	 * Make all the letters in all words uppercase.
	 */
	for($i = 0; $i<$answers; $i++) {
		$words[$i] = mb_strtoupper($_POST['answer'.($i+1)]);
	}
	
	/*
	 * Loop through all the letters in password to check whether the answers contain letters from password.
	 */
	for($i=0; $i<$pass_len; $i++) {
		$word = $words[$i];
		$pass_letter_pos = mb_strpos($word, $password[$i], 0);
		$word_len = mb_strlen($word, "UTF-8");
		
		if(!is_numeric($pass_letter_pos)) {
			header('Location: ./index.php?msg=10&gen=6&word='.$word.'&lett='.$password[$i]);
			exit();
		}
		/*
		 * Word too long, would not fit into crossword. User is allowed to have 11 letters before and 12 letters after the password-letter.
		 */
		if($pass_letter_pos > 11 || $word_len > 23) {
			header('Location: ./index.php?msg=9&gen=6');
			exit();
		}
		/*
		 * Loop through each letter of current word to determine the input-box position and value.
		 */
		for($j=0; $j<$word_len; $j++) {		
			$top = 30 + (38*$i);
			$left = 480;
			
			$new_pos = $j - $pass_letter_pos;
			if($new_pos > 0) {
				$left += ($new_pos * 38);
				$crossword_string .= '
									<input style="top: '.$top.'px; left: '.$left.'px;" class="letterinput" type="text" data-value="'.mb_substr($word,$j,1).'" maxlength="1">';
			} else if($new_pos < 0) {
				$left += ($new_pos * 38);
				$crossword_string .= '
									<input style="top: '.$top.'px; left: '.$left.'px;" class="letterinput" type="text" data-value="'.mb_substr($word,$j,1).'" maxlength="1">';
			} else {
				$crossword_string .= '
									<input style="background-color: #FF1C60; top: '.$top.'px; left: '.$left.'px;" class="letterinput" type="text" data-value="'.mb_substr($word,$j,1).'" maxlength="1">';
			}
			if($j == 0) {
				$small_top = $top + 22;
				$small_left = $left + 3;
				$small_num = $i + 1;
				$answernum_string .= '
									<span class="smallnum" style="color: #000000; position: absolute; top: '.$small_top.'px; left: '.$small_left.'px;">'.$small_num.'</span>';
			}
			$letter_cnt++;
		}
	}
	$new_qs = preg_replace("/[\n\r]/","\\n",$questions);
	
	$name = plCHarset($_POST['gameName']);
	$description = htmlspecialchars($_POST['gameDesc']);
	
	$temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	/*
	* Put generated strings inside corresponding game files.3E7C96
	*/
	recurse_copy('./samples/krzyzowki',$temp); 
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- crossword here --->", $crossword_string.$answernum_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- letter count here --->", $letter_cnt);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- description here --->", $description);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- title here --->", $_POST['gameName']);
	replace_in_file($temp.'/lesson/lesson/index.html', '<--- keywords here --->', '00_gen_cross_'.$name);
	replace_in_file($temp.'/lesson/lesson/scripts/script.js', '<--- questions here --->', $new_qs);	
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);	
 	/*
	* Generate and show a preview from preview.php file.
	*/      
    $FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'crossword.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'crossword.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;
?>