﻿<?php
	require_once('./lib/hzip.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=5');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip'); 
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=5&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=5');
			exit();
		}
	}
	/*
	 * Check for the necessary form inputs.
	 */
    if(empty($_POST['gameName'])) {
		header('Location: index.php?gen=5&msg=4');
		exit();
	}
        
	if(empty($_POST['gameDesc'])) {
		header('Location: index.php?gen=5&msg=7');
		exit();
	}
        
	if(empty($_POST['gameContent'])) {
		header('Location: index.php?gen=5&msg=8');
		exit();
	}
	
	if(!strpos($_POST['gameContent'],'.....')) {
		header('Location: index.php?gen=5&msg=8');
		exit();
	}
	
	/*
	 *	Some variables.
	 */       
	$name = plCHarset($_POST['gameName']);
	$description = htmlspecialchars($_POST['gameDesc']);
	
	$temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	recurse_copy('./samples/uzupelnianki',$temp);  
	
	$content = htmlspecialchars($_POST['gameContent']); 	
	$corr = array( "ó" => "u", "u" => "ó", "rz" => "ż", "ż" => "rz", "h" => "ch", "ch" => "h",);	
	$words = 1;
	$draggable_string = '';
	
	/*
	 * Loop until words/letters/phrases need to be hidden.
	 */
	while(strpos($content,'.....'))
	{
		/*
		 * Get the phrase to be hidden, wrap around HTML, give it value and display as a gap (____).
		 */
		$word[$words] = getStringBetween($content,".....",".....");
		$find = '.....'.$word[$words].'.....';
		$replace = '<span class="gap" data-value="'.$word[$words].'">';
		
		for($i=1; $i<=(mb_strlen($word[$words], "UTF-8")*1); $i++) {
			$replace .= '_';
		}
		
		$replace .= '</span>';		
		$draggable_string .= '<span class="fill" data-target="'.$word[$words].'">'.$word[$words].'</span>';
		
		/*
		 * For single letters contained in an array, show also a letter that is wrong (ie. for "u", show "u" AND "ó").
		 */
		if(mb_strlen($word[$words], "UTF-8") == 1 && array_key_exists($word[$words], $corr)) {	
			$draggable_string .= '<span class="fill" data-target="'.$corr[$word[$words]].'" data-words="'.$words.'">'.$corr[$word[$words]].'</span>';
		}
		
		$content = implode($replace, explode($find, $content, 2));		
		$words++;		
	}	
	$gaps = $words-1;
	
	/*
	 * Put generated strings inside corresponding game files.
	 */
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- text here --->", $content);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- words here --->", $draggable_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- main here --->", '<main data-words="'.$gaps.'">');
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- description here --->", $description);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- title here --->", $_POST['gameName']);
	replace_in_file($temp.'/lesson/lesson/index.html', '<--- keywords here --->', '00_gen_gapfill_'.$name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);
 	/*
	 * Generate and show a preview from preview.php file.
	 */ 	
    $FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'gapfill.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'gapfill.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;

?>