<?php
	require_once('./lib/hzip.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=3');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip'); 
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=3&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=3');
			exit();
		}
	}
    if(empty($_POST['gameName'])) {
		header('Location: index.php?gen=3&msg=4');
		exit();
	}
        
	if(empty($_POST['gameDesc']) || empty($_POST['gameGroups'])) {
		header('Location: index.php?gen=3&msg=666');
		exit();
	}
	
	/*
	 *	Some variables.
	 */       
	$name = plCHarset($_POST['gameName']);
	$description = $_POST['gameDesc'];
	$groups = $_POST['gameGroups'];
	$allowedExts = array("jpeg", "jpg", "png");
	
	
	$temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	recurse_copy('./samples/grupowanie',$temp);  
	
	$main_string = '<main data-groups="'.$groups.'"';
	$inside_main_string = '<div class="itemsbox"></div>';
	$elements_string = '';
	$css_string = '';
	
	for($i=1; $i<=$groups; $i++)
	{
		/*
		 * Get the number of elements for current group, and its name.
		 */
        $elements = $_POST['groupElements'.$i];	
		$groupname = $_POST['groupName'.$i];
		/*
		 * Determine what should be in <main> tag, and generate content to put inside it.
		 */
		$main_string .= ' data-elements'.$i.'="'.$elements.'"';
		$inside_main_string .= '				<div class="dropbox answerbox'.$i.'" data-value="'.$i.'"></div>'.PHP_EOL;
		$inside_main_string .= '				<span class="text'.$i.'">'.$groupname.'</span>'.PHP_EOL;
		for($j=1; $j<=$elements; $j++) {
			/*
			 * Check if text input for current element is not empty (user typed in a word, rather than upload a file).
			 */
			if(!empty($_POST['groupElement_'.$i.'_'.$j])) {
				/*
				 * Generate HTML and CSS strings for text-type elements.
				 */
				$elements_string .= '				<span style="top: 10px; left: 10px;" class="drag element'.$i.'_'.$j.'" data-group="'.$i.'">'.$_POST['groupElement_'.$i.'_'.$j].'</span>'.PHP_EOL;
				$css_string .='				.element'.$i.'_'.$j.' {width: auto; height: auto; position: absolute; cursor: pointer; font-size: 15px; color: #5D5D5D; z-index: 1;}'.PHP_EOL;
			} else {
				/*
				 * Check if a file input for current element is not empty (user uploaded file, rather than type in a word).
				 */
				if(!empty($_FILES['groupElementFile_'.$i.'_'.$j]["name"])) {
					/*
					 * Check if an uploaded file is correct format/size.
					 */
					$tempor = explode(".", $_FILES['groupElementFile_'.$i.'_'.$j]["name"]);
					$extension = end($tempor);
					if ((($_FILES['groupElementFile_'.$i.'_'.$j]["type"] == "image/jpeg")
					|| ($_FILES['groupElementFile_'.$i.'_'.$j]["type"]  == "image/jpg")
					|| ($_FILES['groupElementFile_'.$i.'_'.$j]["type"]  == "image/png")
					|| ($_FILES['groupElementFile_'.$i.'_'.$j]["type"]  == "image/pjpeg")
					|| ($_FILES['groupElementFile_'.$i.'_'.$j]["type"]  == "image/x-png"))
					&& ($_FILES['groupElementFile_'.$i.'_'.$j]["size"]  < 5000000)
					&& in_array($extension, $allowedExts))  {    
						/*
						 * If there is an error set for the file, delete temporary folder and redirect.
						 */                                          
						if($_FILES['groupElementFile_'.$i.'_'.$j]["error"]) {
							header('Location: ./index.php?msg=666&gen=3');
							recurse_delete($temp2);
							exit();
						}
						/*
						 * If everything is okay with an uploaded file, generate 80x80px image, CSS string and HTML string for it.
						 */
						image_resize($_FILES['groupElementFile_'.$i.'_'.$j]["tmp_name"], 80, 80, $temp.'/lesson/lesson/styles/images/group'.$i.'_'.$j.'.png', true);
						$elements_string .= '				<div style="top: 10px; left: 10px;" class="drag element'.$i.'_'.$j.'" data-group="'.$i.'"></div>'.PHP_EOL;
						$css_string .='				.element'.$i.'_'.$j.' {position: absolute; width: 80px; height: 80px; background:url(images/group'.$i.'_'.$j.'.png);}'.PHP_EOL;
					} else {
						/*
						 * If a file is in worng format/size, delete the temporary folder and redirect.
						 */
						recurse_delete($temp2);
                        header('Location: ./index.php?msg=1&gen=3');  
						exit();                                      
					}
				} else {
					/*
					 * If, by somehow, no word has been typed nor a file chosen, delete the temporary folder and redirect with unknown error.
					 */
					recurse_delete($temp2);
					header('Location: index.php?gen=3&msg=666');
					exit();
				}
			}
		}
	}
	/*
	 * Close the <main> tag.
	 */
	$main_string .= '>';
	
	/*
	 * Put generated strings inside corresponding game files.
	 */
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- main here --->", $main_string.$inside_main_string.$elements_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- description here --->", $description);
	replace_in_file($temp.'/lesson/lesson/styles/style.css', "<--- css here --->", $css_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- title here --->", $_POST['gameName']);
	replace_in_file($temp.'/lesson/lesson/index.html', '<--- keywords here --->', '00_gen_group_'.$name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);
 	/*
	 * Generate and show a preview from preview.php file.
	 */    
    $FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'group.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'group.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;
?>