﻿
$(function()
	{
	window.gameOn = true;

	/**
	 * jPlayer
	 */
	 if($('main').data("time") > 0) {
		$('.footer').append('<span class="description">Pozostały czas: <span id="OneHourCountDown"></span>  </span>');
	 }
	$('#jplayer').on($.jPlayer.event.ready,function()
		{
		$('#jplayer').jPlayer('setMedia', {mp3: './media/file1.mp3'});
		});

	/**
	 * Elements
	 */

	var elements = [];
	for(var i=1;i<=25;++i)
	{
		elements[i-1] = i;
	}
	var positions = [
		[-49,-30],[56,-30],[161,-30],[265,-30],[370,-30],
		[-49,80],[56,80],[161,80],[265,80],[370,80],
		[-49,190],[56,190],[161,190],[265,190],[370,190],
		[-49,300],[56,300],[161,300],[265,300],[370,300],
		[-49,410],[56,410],[161,410],[265,410],[370,410],
	];
	var count = 0;
	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div style="position: absolute; right: '+positions[count][0]+'px; top: '+positions[count][1]+'px;" class="element_'+value+'" data-element="'+value+'"/>');
		count++;
		
		});

	/**
	 * Draggable style="background: none; background-color: #ffffff;"
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			cursor: 'move',
			opacity: .7,
			scope: $this.data('element')
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('kind'),

			drop: function(event,ui)
				{
				++counter;

				$(event.target).addClass('ok').droppable('disable');
				$(event.target).css('background', '');
				if(!$("html").hasClass("ie8") ) { 
					ui.helper.css('display','none').draggable('destroy');				
				};
				
				}
			});
		});
	/**
	 * Hint
	 */
	$('a.hint').click(function(e)
		{
		e.preventDefault();
		$('div.hint').fadeToggle();
		});



	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 25)
			{
			$('#jplayer_well').jPlayer('play');
			window.gameOn = false;
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
