<?php
	require_once('./lib/hzip.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=7');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip'); 
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=7&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=7');
			exit();
		}
	}
	
	if(empty($_POST['gameName'])) {
		header('Location: index.php?gen=7&msg=4');
		exit();
	}
        
	if(empty($_POST['gameQuestions'])) {
		header('Location: index.php?gen=7&msg=666');
		exit();
	}
        
	if(empty($_POST['gameTime'])) {
		header('Location: index.php?gen=7&msg=666');
		exit();
	}	
    
	/*
	 *	Some variables.
	 */
	$name = plCHarset($_POST['gameName']);
	$allowedExts = array("jpeg", "jpg", "png");
	$questions = htmlspecialchars($_POST['gameQuestions']);
	$time = htmlspecialchars($_POST['gameTime']);
	$total_points = 0;
	
	$temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	recurse_copy('./samples/testy',$temp); 
	
	$questions_string = '';
	$answers_string = '';
	$images_string = '';
	
	for($i=1; $i<=$questions; $i++) {
		$q_description = nl2br($_POST['questionDesc'.$i]);
		$q_points = $_POST['questionPoints'.$i];
		$total_points += $q_points;
		$q_answer_type = $_POST['questionAnswerType'.$i];
		
		if(!empty($_FILES['questionImage'.$i]['name'])) {
			$tempor = explode(".", $_FILES['questionImage'.$i]["name"]);
			$extension = end($tempor);
			if ((($_FILES['questionImage'.$i]["type"] == "image/jpeg")
				|| ($_FILES['questionImage'.$i]["type"]  == "image/jpg")
				|| ($_FILES['questionImage'.$i]["type"]  == "image/png")
				|| ($_FILES['questionImage'.$i]["type"]  == "image/pjpeg")
				|| ($_FILES['questionImage'.$i]["type"]  == "image/x-png"))
				&& ($_FILES['questionImage'.$i]["size"]  < 5000000)
				&& in_array($extension, $allowedExts)) {  	                                    
				if($_FILES['questionImage'.$i]["error"]) {
					recurse_delete($temp2);
					header('Location: ./index.php?msg=666&gen=7');
					exit();
				}	
				list($width, $height, $type, $attr) = getimagesize($_FILES['questionImage'.$i]["tmp_name"]);
				if($width>400 && $height>400) {		
					image_resize($_FILES['questionImage'.$i]["tmp_name"], 400, 400, $temp.'/lesson/lesson/styles/images/qimage'.$i.'.png', false);
					$images_string .= '	<div style="display: none;" id="image'.$i.'">
											<a href="#hint" class="hint"><div class="image-icon"></div>Pokaż/ukryj obrazek do zadania</a>
											<div style="background: url(./styles/images/qimage'.$i.'.png);" class="hint"></div>	
										</div>'.PHP_EOL;
				} else {
					move_uploaded_file($_FILES['questionImage'.$i]["tmp_name"], $temp.'/lesson/lesson/styles/images/qimage'.$i.'.png');
					$images_string .= '	<div style="display: none;" id="image'.$i.'">
											<a href="#hint" class="hint"><div class="image-icon"></div>Pokaż/ukryj obrazek do zadania</a>
											<div style="width: '.$width.'px; height: '.$height.'px;background: url(./styles/images/qimage'.$i.'.png);" class="hint"></div>	
										</div>'.PHP_EOL;
				}
			} else {				
				recurse_delete($temp2);
				header('Location: ./index.php?msg=1&gen=7');  
				exit();       
			}
		} else {		
			$images_string .= '	<div style="display: none;" id="image'.$i.'">
									<a href="#hint" class="hint">Brak obrazka do zadania</a>
								</div>'.PHP_EOL;
		
		}
		
		if($q_answer_type == 1) {
			$questions_string .= '<p style="display: none;" id="question'.$i.'" data-rightanswer="'.htmlspecialchars($_POST['textAnswer'.$i]).'" data-points="'.$q_points.'">'.PHP_EOL;
			$questions_string .= $q_description.'</p>'.PHP_EOL;
			$answers_string .= '<p style="display: none;" id="answers'.$i.'" data-answertype="1">'.PHP_EOL;
			$answers_string .= '<input id="answer'.$i.'_1" style=" width: 100%;" type="text" name="answer"></p>'.PHP_EOL;
		} else {
			$q_right_answer = $_POST['questionRightAnswer'.$i];
			$questions_string .= '<p style="display: none;" id="question'.$i.'" data-rightanswer="'.$q_right_answer.'" data-points="'.$q_points.'">'.PHP_EOL;
			$questions_string .= $q_description.'</p>';
			$answers_string .= '<p data-answertype="'.$q_answer_type.'">'.PHP_EOL;
			$answers_string .= '<div id="answers'.$i.'" style="display: none; padding-left: 25px; padding-top: 18px;" class="radios" style="padding-left: 10px;">'.PHP_EOL;
			for($j=1; $j<=$q_answer_type; $j++) {
				
				if(!empty($_POST['answerText_'.$i.'_'.$j])) {
					$answer = $_POST['answerText_'.$i.'_'.$j];
					$answers_string .= '<span style="font-size: 15px; word-wrap: break-word;"><input type="radio" name="answer'.$i.'" value="'.$j.'" id="r'.$i.$j.'"><label class="radio" for="r'.$i.$j.'"></label>'.$answer.'</span><br/>'.PHP_EOL;
				} else {
					$answer_file = $_FILES['answerFile_'.$i.'_'.$j];
					$tempor = explode(".", $answer_file["name"]);
					$extension = end($tempor);
					
					if ((($answer_file["type"] == "image/jpeg")
					|| ($answer_file["type"]  == "image/jpg")
					|| ($answer_file["type"]  == "image/png")
					|| ($answer_file["type"]  == "image/pjpeg")
					|| ($answer_file["type"]  == "image/x-png"))
					&& ($answer_file["size"]  < 5000000)
					&& in_array($extension, $allowedExts)) {  	                                    
						if($answer_file["error"]) {
							recurse_delete($temp2);
							header('Location: ./index.php?msg=666&gen=7');
							exit();
						}	
						image_resize($answer_file["tmp_name"], 60, 60, $temp.'/lesson/lesson/styles/images/ansimage'.$i.'_'.$j.'.png');
						$answers_string .= '<span style="font-size: 15px; word-wrap: break-word;"><input type="radio" name="answer'.$i.'" value="'.$j.'" id="r'.$i.$j.'"><label class="radio" for="r'.$i.$j.'"></label><img src="./styles/images/ansimage'.$i.'_'.$j.'.png"/></span><br/>'.PHP_EOL;
					} else {				
						recurse_delete($temp2);
						header('Location: ./index.php?msg=1&gen=7');  
						exit();   
					}
				}
			}
			$answers_string .= '</p>'.PHP_EOL;
			$answers_string .= '</div>'.PHP_EOL;
		}
	}
	$email = $_POST['gameEmail'];
	$checking = $_POST['gameCheckAnswers'];
	$main_string = '<main data-totalquestions="'.$questions.'" data-totalpoints="'.$total_points.'" data-time="'.$time.'" data-email="'.$email.'" data-checking="'.$checking.'">'.PHP_EOL;
	/*
	* Put generated strings inside corresponding game files.
	*/
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- main here --->", $main_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- questions here --->", $questions_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- answers here --->", $answers_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- images here --->", $images_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- title here --->", $_POST['gameName']);
	replace_in_file($temp.'/lesson/lesson/index.html', '<--- keywords here --->', '00_gen_test_'.$name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);
	
 	/*
	* Generate and show a preview from preview.php file.
	*/      
    $FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'test.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'test.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;
?>