<?php
	/*
	 * Delete all files from downloads directory (zip files with games) that were created X days ago.
	 */
	function empty_downloads($days_passed) {
		if ($dir = opendir('./downloads/')) {
			while (false !== ($file = readdir($dir))) { 
				$fpath = './downloads/'.$file;
				if (file_exists($fpath)) {
					$filelastmodified = filemtime($fpath);
					if((time()-$filelastmodified) > $days_passed*24*3600 && is_file($fpath)) {
					   unlink($fpath);
					}
				}
			}
			closedir($dir); 
		}
	}
	
	
	/*
	 * Delete all subdirectories (with all its contents) from the temp directory.
	 * Temp folders may remain if users do not click any of the buttons in preview.
	 */
	function empty_temp($days_passed) {
		if ($dir = opendir('./temp/')) {
			while (false !== ($file = readdir($dir))) { 
				$fpath = './temp/'.$file;
				if (file_exists($fpath) && $file != '.' && $file != '..') {
					$filelastmodified = filemtime($fpath);
					if((time()-$filelastmodified) > $days_passed*24*3600) {
					   recurse_delete($fpath);
					}
				}
			}
			closedir($dir); 
		}
	}
	
	
	/*
	 * Recurse copy (chosen folder with all its content and subdirectories)
	 */	
	function recurse_copy($src,$dst) { 
		$dir = opendir($src); 
		@mkdir($dst); 
		while(false !== ( $file = readdir($dir)) ) { 
			if (( $file != '.' ) && ( $file != '..' )) { 
				if ( is_dir($src . '/' . $file) ) { 
					recurse_copy($src . '/' . $file,$dst . '/' . $file); 
				} 
				else { 
					copy($src . '/' . $file,$dst . '/' . $file); 
				} 
			} 
		} 
		closedir($dir); 
		chmod_r($dst);
	}  
	
	function chmod_r($path) {
		$dir = new DirectoryIterator($path);
		foreach ($dir as $item) {
			chmod($item->getPathname(), 0777);
			if ($item->isDir() && !$item->isDot()) {
				chmod_r($item->getPathname());
			}
		}
	}
	
	/*
	 * Recurse delete (chosen folder with all its content and subdirectories)
	 */
	function recurse_delete($dir) { 
		if (!is_dir($dir) || is_link($dir) && file_exists($dir)) return unlink($dir); 
		foreach (scandir($dir) as $file) { 
			if ($file == '.' || $file == '..') continue; 
			if (!recurse_delete($dir . '/' . $file)) { 
				chmod($dir . '/' . $file, 0777); 
				if (!recurse_delete($dir . '/' . $file)) return false; 
			}; 
		} 
		return rmdir($dir); 
	} 

	
	/*
	 * Image resizer.
	 */
	function image_resize($file, $width, $height, $destination, $transparent = true)
	{
		$w = $width;
		$h = $height;

		list($source_image_width, $source_image_height, $source_image_type) = getimagesize($file);
		switch ($source_image_type) {
			case IMAGETYPE_GIF:
				$original = imagecreatefromgif($file);
				break;
			case IMAGETYPE_JPEG:
				$original = imagecreatefromjpeg($file);
				break;
			case IMAGETYPE_PNG:
				$original = imagecreatefrompng($file);
				break;
		}
		$orig_w = imagesx($original);
		$orig_h = imagesy($original);

		$w_ratio = $orig_w / $w;
		$h_ratio = $orig_h / $h;

		$ratio = $w_ratio > $h_ratio ? $w_ratio : $h_ratio;

		$dst_w = $orig_w / $ratio;
		$dst_h = $orig_h / $ratio;
		$dst_x = ($w - $dst_w) / 2;
		$dst_y = ($h - $dst_h) / 2;

		$src = imagecreatetruecolor($w, $h);
		if($transparent) {
			imagealphablending($src, true);
			imagesavealpha($src, true);
			$bg = imagecolorallocatealpha ( $src, 255, 255, 255, 127 );
			imagefill ( $src, 0, 0, $bg );

			imagecopyresampled($src, $original, $dst_x, $dst_y,0, 0, $dst_w, $dst_h, $orig_w, $orig_h);
			imagepng($src, $destination);
		} else {
			imagecopyresampled($src, $original, $dst_x, $dst_y,0, 0, $dst_w, $dst_h, $orig_w, $orig_h);
			imagejpeg($src, $destination);
		}
		imagedestroy($original);
		imagedestroy($src);
	}
	
	/*
	 * Get rid of any unwanted signs in a string.
	 */
	function plCharset($string) {	
		$string = strtolower($string);
		$polskie = array(',', ' - ',' ','', '', '', '', '', '', '', 's', '', '', '', '', '', '', '', '', '', '','-',"'","/","?", '"', ":", '', '!','.', '&', '&amp;', '#', ';', '[',']','domena.pl', '(', ')', '`', '%', '', '', '');
		$miedzyn = array('-','-','-','e', 'e', 'o', 'o', 'a', 'a', 's', 's', 'l', 'l', 'z', 'z', 'z', 'z', 'c', 'c', 'n', 'n','-',"","","","","",'s','','', '', '', '', '', '', '', '', '', '', '', '', '');
		$string = str_replace($polskie, $miedzyn, $string);	
		/*
		 * Replace anything that is forbidden.
		 */
		$string = preg_replace('/[^0-9a-z\-]+/', '', $string);	
		/*
		 * Only one dash("-") sign between words.
		 */
		$string = preg_replace('/[\-]+/', '_', $string);	
		/*
		 * Delete any dash signs at the beginning and end of a string.
		 */
		$string = trim($string, '-');
		$string = stripslashes($string);	
		/*
		 * Just in case.
		 */
		$string = urlencode($string);	
		return $string;
	}
	
	/*
	 * Replace a string in a file
	 */
	function replace_in_file($FilePath, $OldText, $NewText) {
		$Result = array('status' => 'error', 'message' => '');
		if(file_exists($FilePath)===TRUE) {
			if(is_writeable($FilePath)) {
				try {
					$FileContent = file_get_contents($FilePath);
					$FileContent = str_replace($OldText, $NewText, $FileContent);
					if(file_put_contents($FilePath, $FileContent) > 0) {
						$Result["status"] = 'success';    
					} else {
					   $Result["message"] = 'Error while writing file'; 
					}
				}
				catch(Exception $e) {
					$Result["message"] = 'Error : '.$e; 
				}
			} else {
				$Result["message"] = 'File '.$FilePath.' is not writable !';       
			}
		} else {
			$Result["message"] = 'File '.$FilePath.' does not exist !';
		}
		return $Result;
	}	
	
	/*
	 * Fetch string from inbetween two strings
	 */
	function getStringBetween($str,$from,$to)
	{
		$sub = substr($str, strpos($str,$from)+strlen($from),strlen($str));
		return substr($sub,0,strpos($sub,$to));
	}
?>