<?php
/*
 * @author Trung Thanh Tran <umbalaconmeogia@gmail.com>
 * @link http://www.php.net/manual/de/class.ziparchive.php#110719
 */
class HZip 
{ 
  /** 
   * Add files and sub-directories in a folder to zip file. 
   * @param string $folder 
   * @param ZipArchive $zipFile 
   * @param int $exclusiveLength Number of text to be exclusived from the file path. 
   */ 
  private static function folderToZip($folder, &$zipFile, $exclusiveLength) { 
    $handle = opendir($folder); 
    while (false !== $f = readdir($handle)) { 
      if ($f != '.' && $f != '..') { 
        $filePath = "$folder/$f"; 
        // Remove prefix from file path before add to zip. 
        $localPath = substr($filePath, $exclusiveLength); 
        if (is_file($filePath)) { 
			if(file_exists($filePath)) {
				if(!strpos($filePath, 'Uruchom.html')) {
					if($zipFile->addFile($filePath, $localPath)) {
						//echo 'Added: '.$filePath.'<br />';
					} else {
						//echo 'Open error : '.$filePath.'<br />';
					}
				}
			}
			else
			{
				//echo 'File '.$filePath.' not found<br />';
			}
        } else if (is_dir($filePath)) { 
			if(file_exists($filePath)) {
				if($zipFile->addEmptyDir($localPath))
				{
					self::folderToZip($filePath, $zipFile, $exclusiveLength); 
					//echo 'Added: '.$localPath.'<br />';
				} else {
					//echo 'Open error : '.$localPath.'<br />';
				}
			}
        } 
      } 
    } 
	$zipFile->addFile($folder.'Uruchom.html', 'Uruchom.html');
    closedir($handle); 
  } 

  /** 
   * Zip a folder (include itself). 
   * Usage: 
   *   HZip::zipDir('/path/to/sourceDir', '/path/to/out.zip'); 
   * 
   * @param string $sourcePath Path of directory to be zip. 
   * @param string $outZipPath Path of output zip file. 
   */ 
  public static function zipDir($sourcePath, $outZipPath) 
  { 
    $pathInfo = pathInfo($sourcePath); 
    $parentPath = $pathInfo['dirname']; 
    $dirName = $pathInfo['basename']; 

    $z = new ZipArchive(); 
    $z->open($outZipPath, ZIPARCHIVE::CREATE); 
    $z->addEmptyDir($dirName); 
    self::folderToZip($sourcePath, $z, strlen("$parentPath/")); 
    if($z->close()) {
		echo 'success';
	} else {	
		echo 'error';
	}
  } 
} 
?>