<?php
/**
 * Puzzle - a PHP/Javascript jigsaw puzzle
 *
 * Copyright (C) 2006 David Eder <david@eder.us>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author David Eder <david@eder.us>
 * @copyright 2004 David Eder
 * @package puzzle
 * @version .1
 * @modification Grzegorz Skiba
 */

  define('TOP',    0);
  define('BOTTOM', 1);
  define('LEFT',   2);
  define('RIGHT',  3);
  
	function puzzles_square($rows_columns, $image, $out)
	{
		$img = imagecreatefromjpeg($image);
		$size = 468 / $rows_columns;
		$count = 1;
		
		for($i=0; $i<$rows_columns; $i++) {
			$x = 0+($size*$i);
			for($j=0; $j<$rows_columns; $j++) {
				$y = 0+($size*$j);
				
				$puzzle = imagecreatetruecolor($size, $size);
				imagecopy($puzzle, $img, 0, 0, $y, $x, 468, 468);

				imagepng($puzzle, $out.'puzzle'.$count.'.png');
				$count++;
			}
		}
	}
	
	function puzzles($rows_columns, $image, $out)
	{
		$img = $image;
		$rows = $cols = $rows_columns;
		$cnt = 1;
		

		for($r = 0; $r < ($rows+1); $r++)
		{
			for($c = 0; $c < ($cols+1); $c++)
			{
				$h[$r][$c] = (rand(0, 100) > 50) ? 1 : 0;
				$v[$r][$c] = (rand(0, 100) > 50) ? 1 : 0;
			}
		}
		list($width, $height) = getimagesize($img);

		$d = floor(min($width / $cols, $height / $rows) / 5);

		$vw = floor($width / $cols);
		$vh = floor($height / $rows);

		$iw = $vw + 2 * $d;
		$ih = $vh + 2 * $d;

		$xinc = $vw;
		if($xinc % 4 == 0) $xinc /= 4;
		elseif($xinc % 3 == 0) $xinc /= 3;
		elseif($xinc % 2 == 0) $xinc /= 2;

		$yinc = $vh;
		if($yinc % 4 == 0) $yinc /= 4;
		elseif($yinc % 3 == 0) $yinc /= 3;
		elseif($yinc % 2 == 0) $yinc /= 2;

		$img = urlencode(basename($img));

		for($r = 0; $r < $rows; $r++)
		{
			for($c = 0; $c < $cols; $c++)
			{
				$g = chr(65+bindec($v[$r][$c] . (1-$v[$r+1][$c]) . $h[$r][$c] . (1-$h[$r][$c+1])));
				generate_puzzle($image, $r, $c, $cols, $rows, $d, $g, $cnt, $out);
				$cnt++;
			}
		}
	}

	function generate_puzzle($image, $row, $column, $cols, $rows, $d_var, $g_var, $count, $output)
	{
		$d = $d_var;

		$r = $row;
		$c = $column;

		$rr = $rows;
		$cc = $cols;
	  
		$cnt = $count;

		$g = str_pad(decbin(ord($g_var) - 65), 4, '0', STR_PAD_LEFT);

		if($r == 0) $g{TOP} = '0';
		if($r == $rr - 1) $g{BOTTOM} = '0';
		if($c == 0) $g{LEFT} = '0';
		if($c == $cc - 1) $g{RIGHT} = '0';

		$img = imagecreatefromjpeg($image);

		$w = floor(imagesx($img) / $cc);
		$h = floor(imagesy($img) / $rr);

		$x = $c * $w;
		$y = $r * $h;

		$width = 2 * $d + $w;
		$height = 2 * $d + $h;
		
		$chop = imagecreatetruecolor($width, $height);
		imageSaveAlpha($chop, true);
		imageAlphaBlending($chop, false);
		$trans = imagecolorallocatealpha($chop, 0, 0, 0, 127);
		imagefill($chop, 0, 0, $trans);

		imagecopy($chop, $img, 0, 0, $x - $d, $y - $d, $width, $height);

		if($c == 0 || !$g[LEFT]) imagefilledrectangle($chop, 0, 0, $d - 1, $height, $trans);
		if($c != 0)
		{
			if($g[LEFT]) overlay($chop, 0, 0, $d, $height, 1, $trans, 1.3, 2);
			else         overlay($chop, $d, 0, $d, $height, 0, $trans, 2.7, 2);
		}

		if($c == $cc - 1 || !$g[RIGHT]) imagefilledrectangle($chop, $width - $d, 0, $width, $height, $trans);
		if($c != $cc - 1)
		{
			if($g[RIGHT]) overlay($chop, $width - $d, 0, $d, $height, 1, $trans, 2.7, 2);
			else          overlay($chop, $width - 2 * $d, 0, $d, $height, 0, $trans, 1.3, 2);
		}

		if($r == 0 || !$g[TOP]) imagefilledrectangle($chop, 0, 0, $width, $d - 1, $trans);
		if($r != 0)
		{
			if($g[TOP]) overlay($chop, 0, 0, $width, $d, 1, $trans, 2, 1.3);
			else overlay($chop, 0, $d, $width, $d, 0, $trans, 2, 2.7);
		}

		if($r == $rr - 1 || !$g[BOTTOM]) imagefilledrectangle($chop, 0, $height - $d, $width, $height, $trans);
		if($r != $rr - 1)
		{
			if($g[BOTTOM]) overlay($chop, 0, $height - $d, $width, $d, 1, $trans, 2, 2.7);
			else overlay($chop, 0, $height - 2 * $d, $width, $d, 0, $trans, 2, 1.3);
		}
		imagepng($chop, $output.'puzzle'.$cnt.'.png');
	}

	function generate_puzzle2($image, $row, $column, $cols, $rows, $d_var, $g_var, $count, $output)
	{
		$d = $d_var;

		$r = $row;
		$c = $column;

		$rr = $rows;
		$cc = $cols;
	  
		$cnt = $count;

		$g = str_pad(decbin(ord($g_var) - 65), 4, '0', STR_PAD_LEFT);

		if($r == 0) $g{TOP} = '0';
		if($r == $rr - 1) $g{BOTTOM} = '0';
		if($c == 0) $g{LEFT} = '0';
		if($c == $cc - 1) $g{RIGHT} = '0';

		$img = imagecreatefromjpeg($image);

		$w = floor(imagesx($img) / $cc);
		$h = floor(imagesy($img) / $rr);

		$x = $c * $w;
		$y = $r * $h;

		$width = 2 * $d + $w;
		$height = 2 * $d + $h;
		
		$chop = imagecreatetruecolor($width, $height);
		imageSaveAlpha($chop, true);
		imageAlphaBlending($chop, false);
		$trans = imagecolorallocatealpha($chop, 0, 0, 0, 127);
		imagefill($chop, 0, 0, $trans);

		imagecopy($chop, $img, 0, 0, $x - $d, $y - $d, $width, $height);

		if($c == 0 || !$g[LEFT]) imagefilledrectangle($chop, 0, 0, $d - 1, $height, $trans);

		if($c == $cc - 1 || !$g[RIGHT]) imagefilledrectangle($chop, $width - $d, 0, $width, $height, $trans);

		if($r == 0 || !$g[TOP]) imagefilledrectangle($chop, 0, 0, $width, $d - 1, $trans);

		if($r == $rr - 1 || !$g[BOTTOM]) imagefilledrectangle($chop, 0, $height - $d, $width, $height, $trans);
		imagepng($chop, $output.'puzzle'.$cnt.'.png');
	}
  

  function overlay($img, $x, $y, $w, $h, $z, $trans, $wdiv, $hdiv)
  {
    $mask = imagecreatetruecolor($w, $h);
    $c[0] = imagecolorallocate($mask, 255, 0, 255);
    $c[1] = imagecolorallocate($mask, 0, 0, 127);
    imagefilledrectangle($mask, 0, 0, imagesx($mask), imagesy($mask), $c[1-$z]);
    imagefilledellipse($mask, $w / $wdiv, $h / $hdiv, min($w, $h), min($w, $h), $c[$z]);
    imagecolortransparent($mask, $c[1]);

    imagecopymerge($img, $mask, $x, $y, 0, 0, $w, $h, 100);

    if($z)
    {
      imagefill($img, $x, $y, $trans);
      imagefill($img, $x + imagesx($mask) - 1, $y + imagesy($mask) - 1, $trans);
    }
    else
      imagefill($img, $x + $w / 2, $y + $h / 2, $trans);

    imagedestroy($mask);
  }

?>
