<?php
	require_once('./lib/hzip.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=4');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip'); 
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=4&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=4');
			exit();
		}
	}
	if(empty($_POST['gameName'])) {
		header('Location: index.php?gen=4&msg=4');
		exit();
	}
    
	/*
	 *	Some variables.
	 */
	$name = plCHarset($_POST['gameName']);
	$groups = $_POST['gamePairs'];
	$allowedExts = array("jpeg", "jpg", "png");
	
	
	$temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	recurse_copy('./samples/parowanie',$temp);  
	
	$main_string = ''; //HTML
	$elements_string = '';  //HTML
	$css_string = ''; //CSS
	$kind_string = '(kind[i][0]===0) '; //JS
	
	for($i=1; $i<=$groups; $i++)
	{
		/*
		 * Add $groups amount of boxes.
		 */
		$main_string .= '<div class="box" data-kind="'.$i.'"></div>'.PHP_EOL;
		if($i > 1) $kind_string .= '&& (kind[i]['.($i-1).']===0) ';
		for($j=1; $j<=2; $j++) {
			/*
			 * Check if text input for current element is not empty (user typed in a word, rather than upload a file).
			 */
			if(!empty($_POST['pairElement_'.$i.'_'.$j])) {
				/*
				 * Generate HTML and CSS strings for text-type elements.
				 */
				$elements_string .= '				<div class="element_'.$i.'_'.$j.'" data-text="'.$_POST['pairElement_'.$i.'_'.$j].'"></div>'.PHP_EOL;
				$css_string .='				.element_'.$i.'_'.$j.' {background: none; width: auto; height: auto; cursor: pointer; font-size: 15px; color: #5D5D5D}'.PHP_EOL;
			} else {
				/*
				 * Check if a file input for current element is not empty (user uploaded file, rather than type in a word).
				 */
				if(!empty($_FILES['pairElementFile_'.$i.'_'.$j]["name"])) {
					/*
					 * Check if an uploaded file is correct format/size.
					 */
					$tempor = explode(".", $_FILES['pairElementFile_'.$i.'_'.$j]["name"]);
					$extension = end($tempor);
					if ((($_FILES['pairElementFile_'.$i.'_'.$j]["type"] == "image/jpeg")
					|| ($_FILES['pairElementFile_'.$i.'_'.$j]["type"]  == "image/jpg")
					|| ($_FILES['pairElementFile_'.$i.'_'.$j]["type"]  == "image/png")
					|| ($_FILES['pairElementFile_'.$i.'_'.$j]["type"]  == "image/pjpeg")
					|| ($_FILES['pairElementFile_'.$i.'_'.$j]["type"]  == "image/x-png"))
					&& ($_FILES['pairElementFile_'.$i.'_'.$j]["size"]  < 5000000)
					&& in_array($extension, $allowedExts))  {    
						/*
						 * If there is an error set for the file, delete temporary folder and redirect.
						 */                                    
						if($_FILES['pairElementFile_'.$i.'_'.$j]["error"]) {
							recurse_delete($temp2);
							header('Location: ./index.php?msg=666&gen=4');
							exit();
						}
						/*
						 * If everything is okay with an uploaded file, generate 80x80px image and CSS string for it.
						 */
						image_resize($_FILES['pairElementFile_'.$i.'_'.$j]["tmp_name"], 80, 80, $temp.'/lesson/lesson/styles/images/pair'.$i.'_'.$j.'.png');
						$css_string .='				.element_'.$i.'_'.$j.' {width:80px;height:80px;background:url(images/pair'.$i.'_'.$j.'.png);}'.PHP_EOL;
					} else {
						/*
						 * If a file is in worng format/size, delete the temporary folder and redirect.
						 */
						recurse_delete($temp2);
						header('Location: ./index.php?msg=1&gen=4');  
						exit();                                      
					}
				} else {
					/*
					 * If, by somehow, no word has been typed nor a file chosen, delete the temporary folder and redirect with unknown error.
					 */
                    recurse_delete($temp2);
					header('Location: index.php?gen=4&msg=666');
					exit();
				}
			}
		}
	}	
	
	/*
	* Put generated strings inside corresponding game files.
	*/
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- main here --->", $main_string.$elements_string);
	replace_in_file($temp.'/lesson/lesson/styles/style.css', "<--- css here --->", $css_string);
	replace_in_file($temp.'/lesson/lesson/scripts/script.js', "var groups = 2;", 'var groups = '.$groups.';');
	replace_in_file($temp.'/lesson/lesson/scripts/script.js', "<--- kind string --->", $kind_string);
	replace_in_file($temp.'/lesson/lesson/index.html', "<--- title here --->", $_POST['gameName']);
	replace_in_file($temp.'/lesson/lesson/index.html', '<--- keywords here --->', '00_gen_pair_'.$name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);
	
 	/*
	* Generate and show a preview from preview.php file.
	*/      
    $FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'pair.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'pair.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;
?>