<?php
	require_once('./lib/hzip.php');
	require_once('./lib/puzzle.php');
	require_once('functions.php');
	
	if(isset($_GET['prev']) && isset($_GET['game']) && isset($_GET['name'])) {
		if($_GET['prev'] == 0) {
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?gen=1');
			exit();		
		} else if($_GET['prev'] == 1) {
			/*
			 * Create zip archive with contents from temporary folder.
			 */
			$file_name = $_GET['name'].time();
			HZip::zipDir('./temp/'.$_GET['game'].'/'.$_GET['name'].'/', 'downloads/'.$file_name.'.zip');
			/*
			 * Delete the temporary folder and redirect to download page.
			 */
			recurse_delete('./temp/'.$_GET['game']); 
			header('Location: ./index.php?msg=2&gen=1&game='.$file_name);	
			exit();	
		} else { 
			header('Location: ./index.php?msg=4&gen=1');
			exit();
		}
	}
	
	if(empty($_POST['gameName'])) {
		header('Location: ./index.php?msg=4&gen=1');
		exit();
	}
	
	/*
	 * Some variables and checking if an uploaded image is correct type and file size.
	 */	
	$type = $_POST['size'];
	$name = plCHarset($_POST['gameName']);
	$allowedExts = array("jpeg", "jpg", "png");
	$temp = explode(".", $_FILES["file"]["name"]);
	$extension = end($temp);
	
	if ((($_FILES["file"]["type"] == "image/jpeg")
		|| ($_FILES["file"]["type"] == "image/jpg")
		|| ($_FILES["file"]["type"] == "image/png")
		|| ($_FILES["file"]["type"] == "image/pjpeg")
		|| ($_FILES["file"]["type"] == "image/x-png"))
		&& ($_FILES["file"]["size"] < 2000000)
		&& in_array($extension, $allowedExts)) 
	{
		if ($_FILES["file"]["error"] > 0) {
			if($_FILES["file"]["error"] == 4) {
				header('Location: ./index.php?msg=3&gen=1');
				exit();
			} else header('Location: ./index.php?msg=666&gen=1');
			exit();
		}
		$image = $_FILES["file"]["tmp_name"];
	} else if(!empty($_POST["localImage"])) {
		$image = './css/images/sample_puzz'.$_POST["localImage"].'.jpg';
	} else {
		header('Location: ./index.php?msg=1&gen=1');
		exit();
	}
	
	/*
	 * Create temporary directory.
	 */
	 $temp_folder_name = 'temp'.time();
	$temp2 = './temp/'.$temp_folder_name;
	mkdir($temp2);
	$temp = $temp2.'/'.$name;
	
	
	/*
	 * Copy sample of puzzles. Type >5 - square puzzles. 
	 */
	 if($type>5) {
		$type_tmp = $type - 3;
		recurse_copy('./samples/puzzle/sample_square_'.$type_tmp.'x'.$type_tmp,$temp);  
	 } else {
		recurse_copy('./samples/puzzle/sample_'.$type.'x'.$type,$temp);  
	 }
	 //rename($temp.'/Uruchom.html', $temp2.'/Uruchom.html');
	
	/*
	 * Puzzle size.
	 */
	$rows_cols = $type;
	list($width, $height) = getimagesize($image);
	
	
	/*
	 * If image smaller than 468x468, then redirect with an error message.
	 */
	if(($width<468) || ($height<468)) {
		recurse_delete($temp2);
		header('Location: index.php?msg=1&gen=1');
		exit();
	}
	
	/*
	 * Resize uploaded image first, to create a hint and an image ready for cutting into puzzles.
	 */
	image_resize($image, 468, 468, $temp.'/lesson/lesson/styles/images/image.jpg', false);
	image_resize($image, 250, 250, $temp.'/lesson/lesson/styles/images/hint.png', false);
	
	/*
	 * Start puzzle generation proccess.
	 */
	 if($type>5) {
		$type -= 3;
		puzzles_square($type, $temp.'/lesson/lesson/styles/images/image.jpg', $temp.'/lesson/lesson/styles/images/');
	 } else {
		puzzles($rows_cols, $temp.'/lesson/lesson/styles/images/image.jpg', $temp.'/lesson/lesson/styles/images/');
	 }
	
	/*
	 * Get a rid of the resized image. It's not needed anymore.
	 */
	unlink($temp.'/lesson/lesson/styles/images/image.jpg');
	
	
	/*
	 * Change some HTML parameters to give an app a name.
	 */
	replace_in_file($temp.'/lesson/lesson/index.html', "<title>Puzzle na piątke.</title>", '<title>'.$_POST['gameName'].'</title>');
	replace_in_file($temp.'/lesson/lesson/index.html', '<meta name="keywords" content="68_mat_puzzle na piatke)"/>', '<meta name="keywords" content="00_gen_puzzle_'.$name.'"/>');
	replace_in_file($temp.'/Uruchom.html', '<--- game name here --->', $name);
	replace_in_file($temp.'/Uruchom.html', '<--- game name2 here --->', $name);
	if(!empty($_POST['gameTime'])) {
		replace_in_file($temp.'/lesson/lesson/index.html', 'data-time="0"', 'data-time="'.$_POST['gameTime'].'"');
	}
	/*
	 * Generate and show a preview from preview.php file.
	 */
	$FileContent = file_get_contents('./preview.php');
	$FileContent = str_replace("puzzle.php?prev=1&game=", 'puzzle.php?prev=1&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("puzzle.php?prev=0&game=", 'puzzle.php?prev=0&game='.$temp_folder_name.'&name='.$name, $FileContent);
	$FileContent = str_replace("temporary_folder_index", './temp/'.$temp_folder_name.'/'.$name.'/lesson/lesson/index.html', $FileContent);
	echo $FileContent;
?>