<?php

class AppController extends Controller {

	/**
	 * @var User
	 */
	var $User;
	/**
	 * @var EmailComponent
	 */
	var $Email;
	var $helpers = array('Html', 'Form', 'Session', 'Asset.asset');
	var $components = array(
		'Session', 'Security',
		'Auth', 'Settings.Config', 'Email',
		'DebugKit.Toolbar' => array('panels' => array('history' => false)),
		'NewFilter'
	);

	/**
	 * Funkcja pobiera numery ID klas do których przypisany jest zalogowany użytkownik
	 * w zależności czy uzytkownik jest uczniem, nauczycielem, bądź administratorem.
	 * @return Array
	 */
	function getClassesId() {
		if ($this->Auth->user('admin')) {
			if(!isset($this->Classes)) $this->loadModel('Learning.Classes');
			return $this->Classes->find('list', array('fields' => array('id', 'id'))); // nie jest to zbyt optymalne.
		}

		if ($this->Auth->user('teacher')) {
			$this->loadModel('Learning.TeacherClass');
			return $this->TeacherClass->getTeacherClasses($this->TeacherClass->Teacher->field('id', array('user_id' => $this->Auth->user('id'))));
		}

		$this->loadModel('Account.Profile');
		return $this->Profile->field('class_id', array('user_id' => $this->Auth->user('id')));
	}

	function message($string = null, $redirect = null, $class = 'message') {
		$this->Config->message($string, $redirect, $class);
	}

	function alert($string, $redirect = null) {
		$this->Config->alert($string, $redirect);
	}

	function beforeFilter() {
		$this->Config->start();
		$this->Auth->userScope = array('User.banned' => 0, 'User.active' => 1, 'OR' => array('Profile.active' => 1, 'User.admin >=' => 1, 'User.teacher' => 1));
		if (!empty($this->params['teacher'])) {
			$this->layout = 'teacher';
		}
		$ver = (int)substr($_SERVER['HTTP_USER_AGENT'], strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')+strlen('MSIE')+1, 3);
		if($ver === 6){
			if($this->params['url']['url'] != 'ie6') {
				$this->redirect('/ie6');
			} 
		}

		if($this->params['url']['url'] == 'ie6') {
			$this->layout = 'login';
			$this->Auth->allow('display');
		}
	}

	function beforeRender() {
		if ($this->Auth->user('id')) {
			$this->loadModel('Account.User');
			$this->set('profileData',
				$this->User->get($this->Auth->user('id'), array(), array('Profile' => array('School' => array('fields' => 'School.*'))))
			);
		}
	}

	function isAuthorized() {
		return true;
	}

}
