<?php

App::import('Lib', 'LazyModel.LazyModel');

class AppModel extends LazyModel {

	public $cacheQueries = true;
	var $recursive = -1;
	var $actsAs = array('Containable');

	function beforeSave() {
		$this->query('SET CHARACTER SET UTF8');
		return true;
	}

	function beforeFind($query) {
		$this->query('SET CHARACTER SET UTF8');
		$this->query('SET lc_time_names = "pl_PL";');
		
		return $query;
	}

	/**
	 * Adds locale functions to errors.
	 *
	 * @param string $field
	 * @param mixed $value
	 * @return string
	 */
	function invalidate($field, $value = true) {
		return parent::invalidate($field, __d('forum', $value, true));
	}

	public function get($id, $fields = array(), $contain = false) {
		if (is_array($id)) {
			$conditions = $id;
		} else {
			$conditions = array($this->alias . '.id' => $id);
		}

		if (empty($fields)) {
			$fields = $this->alias . '.*';
		} else {
			foreach ($fields as $row => $field) {
				$fields[$row] = $this->alias . '.' . $field;
			}
		}

		return $this->find('first', array(
			'conditions' => $conditions,
			'fields' => $fields,
			'contain' => $contain
		));
	}

	public function isMatch($data, $confirmField) {
		$data = array_values($data);
		$var1 = $data[0];
		$var2 = (isset($this->data[$this->name][$confirmField])) ? $this->data[$this->name][$confirmField] : '';

		return ($var1 === $var2);
	}

	public function update($id, $data) {
		$this->id = $id;
		return $this->save($data, false, array_keys($data));
	}

	public function validates($options = array()) {
		// copy the data over from a custom var, otherwise
		$actionSet = 'validate' . Inflector::camelize(Router::getParam('action'));
		if (isset($this->validationSet)) {
			$temp = $this->validate;
			$param = 'validate' . $this->validationSet;
			$this->validate = $this->{$param};
		} elseif (isset($this->{$actionSet})) {
			$temp = $this->validate;
			$param = $actionSet;
			$this->validate = $this->{$param};
		}

		$errors = $this->invalidFields($options);

		// copy it back
		if (isset($temp)) {
			$this->validate = $temp;
			unset($this->validationSet);
		}

		if (is_array($errors)) {
			return count($errors) === 0;
		}
		return $errors;
	}


}
