<?php

/**
 * Można filtrować!
 * Przykład:
 * w metodzie admin_index na początku:
 * 		$this->Filter->filter(
  array(
  'active'=>array('Opinion.active = #replace#'),
  'author'=>array(
  'or'=>array(
  'User.username LIKE "%#replace#%"',
  'User.email LIKE "%#replace#%"',
  'Opinion.author LIKE "%#replace#%"',
  )
  ),
  'created'=>array('Opinion.created >= DATE_FORMAT("#replace#","%Y-%c-%e 00:00:00") AND Opinion.created <= DATE_FORMAT("#replace2#","%Y-%c-%e 23:59:59")'),
  'discussions_count'=>array('Opinion.discussions_count BETWEEN "#replace#" and "#replace2#"'),
  'school'=>array('School.name LIKE "%#replace#%"'),
  'grade'=>array('Opinion.grade BETWEEN "#replace#" and "#replace2#"'),
  'oid'=>array('Opinion.id BETWEEN "#replace#" and "#replace2#"'),
  'phrase'=>array('or'=>array('Opinion.body LIKE "%#replace#%"'))

  ),
  'Opinion'
  );

 * Na początku są nazwy kluczy formularzy, a ostatni parametr to nazwa modelu, jeśli wystąpi #replace2# to podzieli na przedział.
 */
class FilterComponent extends Object {

     var $components = array('RequestHandler');

     function initialize(&$controller, $settings = array()) {
	  $this->controller = & $controller;
	  $this->settings = $settings;
     }

     /**
      * Funkcja filtrująca
      *
      * @param array $options Opcje
      * @param string $model Nazwa modelu do filtrowania
      * @param string $modelMultiple Model dodatkowy do filtrowania według selecta
      * @return null
      * @access public
      */
     function filter($options, $model, $modelMultiple = null) {

	  if (!empty($this->controller->data[$model]) || !empty($this->controller->data[$modelMultiple])) {
	       if (!$this->RequestHandler->isAjax()) {
		    $this->controller->redirect(
			    array('action' => $this->controller->action)
			    + (!empty($this->controller->data[$model]) ? $this->controller->data[$model] : array())
			    + (!empty($this->controller->params['pass']) ? $this->controller->params['pass'] : array())
			    + (($modelMultiple && !empty($this->controller->data[$modelMultiple]) )? $this->encodeMultipleField($this->controller->data[$modelMultiple], $modelMultiple) : array())
		    );
	       }
	  } else {

	       $this->controller->data[$model] = $this->controller->params['named'];
	       if ($modelMultiple && !empty($this->controller->params['named'][$modelMultiple]))
		    $this->controller->data[$modelMultiple] = $this->decodeMultipleField($this->controller->params['named'][$modelMultiple]);
	  }

	  $conditions = array();

	  if (!empty($this->controller->data)) {
	       foreach ($this->controller->data[$model] as $key => $value) {
		    if ($value !== null && array_key_exists($key, $options)) {

			 if (is_array($options[$key])) {
			      if ($modelMultiple && $key == $modelMultiple) {

				   $fields = $this->decodeMultipleField($value);

				   $ids = $this->getIdsFromModelMultiple($fields, $modelMultiple);

				   $condition = $this->recursiveArrayReplace("#replace#", implode(',', $ids), $options[$key]);
				   if(is_array($condition)) $condition = end($condition);
			      } elseif ($this->recursiveArraySearch($options[$key], '#replace2#', true) !== false) {

				   if (strpos($value, '::') !== false) {
					// są wartości dla between
					$values = explode('::', $value);

					$condition = $this->recursiveArrayReplace("#replace#", $values[0], $options[$key]);
					$condition = $this->recursiveArrayReplace("#replace2#", $values[1], $condition);
				   } else {
					// brak wartosci 2, należy skopiować wartość 1
					$condition = $this->recursiveArrayReplace("#replace#", $value, $options[$key]);
					$condition = $this->recursiveArrayReplace("#replace2#", $value, $condition);
				   }
			      } else {
				   // nie ma between
				   $condition = $this->recursiveArrayReplace("#replace#", $value, $options[$key]);
			      }
			      $conditions[] = $condition;
			 }

			 else
			      $conditions[$key] = $value;
		    }
	       }

	       // HABTM filter patch:
	  }

	  $this->controller->paginate[$model]['conditions'] = $conditions;
     }

     function addDataToModelMultiple($model, $modelMultiple) {
	  $this->controller->data[$model][$modelMultiple] = implode(',', $this->getIdsFromModelMultiple($model, $modelMultiple));
     }

     /**
      * Zwraca IDki do filtrowania według selectów, lub checkboxów - z tymi samymi nazwami.
      * @param string $model
      * @param string $modelMultiple
      */
     function getIdsFromModelMultiple($data, $modelMultiple) {
	  $modelMultipleData = array();

	  foreach ($data as $group_id) {
	       if (!empty($group_id)) {
		    if (!is_array($group_id)) {
			 $modelMultipleData[] = $group_id;
		    } else {
			 foreach ($group_id as $g_id) {
			      if ($g_id)
				   $modelMultipleData[] = $g_id;
			 }
		    }
	       }
	  }

	  return $modelMultipleData;
     }

     function encodeMultipleField($data, $multipleModel) {
	  $return = array();
	  if (empty($data))
	       return array();

	  if (!empty($data)) {
	       foreach ($data as $id => $group) {
		    if (is_array($group)) {
			 foreach ($group as $group_id) {
			      if ($group_id)
				   $return[] = $id . ',' . $group_id;
			 }
		    } else {
			 if ($group)
			      $return[] = $id . ',' . $group;
		    }
	       }
	  }

	  return array($multipleModel => implode(';', $return));
     }

     function decodeMultipleField($data) {
	  $return = array();

	  $rows = explode(';', $data);

	  foreach ($rows as $row) {
	       $cols = explode(',', $row);
	       if (!empty($cols[0]) && !empty($cols[1])
		    )$return[$cols[0]][] = $cols[1];
	  }

	  return $return;
     }

     function recursiveArrayReplace($find, $replace, $data) {

	  if (is_array($data)) {
	       foreach ($data as $key => $value) {
		    if (is_array($value)) {
			 $data[$key] = $this->recursiveArrayReplace($find, $replace, $data[$key]);
		    } else {
			 $data[$key] = str_replace($find, $replace, $value);
		    }
	       }
	  } else {
	       $data = str_replace($find, $replace, $data);
	  }

	  return $data;
     }

     function recursiveArraySearch($haystack, $needle, $partial_matches = false, $search_keys = false) {
	  if (!is_array($haystack))
	       return false;
	  foreach ($haystack as $key => $value) {
	       $what = ($search_keys) ? $key : $value;
	       if ($needle === $what)
		    return $key;
	       else if ($partial_matches && @strpos($what, $needle) !== false)
		    return $key;
	       else if (is_array($value) && $this->recursiveArraySearch($value, $needle, $partial_matches, $search_keys) !== false)
		    return $key;
	  }
	  return false;
     }

     function _cleanSpaces($data) {
	  return $this->recursiveArrayReplace(" ", null, $data);
     }

}