<?php

class NewFilterComponent extends Object {

	public $components = array('RequestHandler');
	
	private $__customOptions = array(
		'yes-no' => array(1 => 'tak', 0 => 'nie')
	);
	
	private $__slashReplace = '_slash_';

/**
 * Typy filtrowania użyte w systemie
 * @var type 
 */
	private $__condTypes = array(
		'between' => array(// dla wartości liczbowych
			'#model#.#field# >= #replace#',
			'#model#.#field# <= #replace2#'
		),
		'equal' => '#model#.#field# = #replace#', // równe
		'date_between' => array(
			'DATE(#model#.#field#) >= DATE("#replace#")',
			'DATE(#model#.#field#) <= DATE("#replace2#")'
		),
		'like' => '#model#.#field# LIKE "%#replace#%"',
		'llike' => '#model#.#field# LIKE "%#replace#"',
		'rlike' => '#model#.#field# LIKE "#replace#%"',
	);
	
	private $__defaultOptions = array(
		'__empty' => array('label' => false, 'type' => 'text'),
		'equal' => array('label' => false, 'type' => 'text'),
		'like' => array('label' => false, 'type' => 'text'),
		'between' => array('label' => false, 'type' => 'text', 'class' => 'from_to'),
		'date_between' => array('label' => false, 'type' => 'text', 'class' => 'datepicker')
	);

/**
 * Informacja o aktualnie użytym modelu
 * @var type 
 */
	private $__model;

/**
 * Initialize
 * @param type $controller
 * @param type $settings 
 */
	public function initialize(Controller $controller, $settings = array()) {
		$this->controller = $controller;
		$this->settings = $settings;
	}

/**
 * Funkcja filtrująca
 *
 * @param array $options Opcje
 * @param string $model Nazwa modelu do filtrowania
 * @param string $modelMultiple Model dodatkowy do filtrowania według selecta
 * @return null
 * @access public
 */
	public function filter($options, $model, $modelMultiple = null) {

		if (!isset($this->controller->paginate[$model]['order'])) {
			$this->controller->paginate[$model]['order'] = array($model . '.id' => 'DESC');
		}

		$this->__model = $model;

		if (!empty($this->controller->data['Filter'])
				|| !empty($this->controller->data[$modelMultiple])) {

			$this->__redirectNamed();
		} else {
			$this->__setData($options);
		}

		$conditions = array();

		if (!empty($this->controller->data)) {
			$options = $this->parseOptions($options, $this->controller->data['Filter']);

			foreach ($this->controller->data['Filter'] as $key => $value) {
				if ($value !== null && array_key_exists($key, $options)) {

					if (isset($options[$key])) {

						if ($this->recursiveArraySearch($options[$key], '#replace2#', true) !== false) {

							if (strpos($value, '::') !== false) {
								// są wartości dla between
								$values = explode('::', $value);

								$condition = $this->recursiveArrayReplace("#replace#", $values[0], $options[$key]);
								$condition = $this->recursiveArrayReplace("#replace2#", $values[1], $condition);
							} else {
								// brak wartosci 2, należy skopiować wartość 1
								$condition = $this->recursiveArrayReplace("#replace#", $value, $options[$key]);
								$condition = $this->recursiveArrayReplace("#replace2#", $value, $condition);
							}
						} else {
							// nie ma between
							$condition = $this->recursiveArrayReplace("#replace#", $value, $options[$key]);
						}
						$conditions[] = $condition;
					} elseif ($key !== false) {

						$conditions[$key] = $value;
					}
				}
			}


			// HABTM filter patch:
		}

		$this->controller->paginate[$model]['conditions'] = $conditions;

		return $conditions;
	}

/**
 * Funkcja przekierowuje na parametry nazwane korzystając z danych formularza 
 */
	private function __redirectNamed() {
		if (!$this->RequestHandler->isAjax()) {
			$paramsPass = $this->controller->params['pass'];
			$filterRedir = array();
			foreach ($this->controller->data['Filter'] as $key => $value) {
				if ($value || is_numeric($value))
					$value = str_replace('/',$this->__slashReplace, $value);
					$filterRedir[$key] = $value;
			}

			$this->controller->redirect(
					array('action' => $this->controller->action)
					+ $filterRedir
					+ $paramsPass
			);
		}
	}

/**
 * Parsowanie opcji dla warunków
 * @param type $options
 * @param type $data
 * @return type 
 */
	public function parseOptions($options, $data) {

		$parsed = array();

		$basicOptions = $options['basic'];

		$advancedOptions = !empty($options['advanced']) ? $options['advanced'] : array();
		if (!$basicOptions) {
			throw new Exception("Brak filtrów podstawowych");
		}

		foreach ($basicOptions + $advancedOptions as $field => $option) {
			if (is_array($option)) {

				if (isset($option['cond-switch'])) {
					if (isset($data[$field])) {
						if (isset($option['cond-switch'][$data[$field]])) {
							$cond = $option['cond-switch'][$data[$field]];
						}
					}
				} elseif (!isset($option['cond'])) {
					$cond = $this->__getCond($field, $option);
				} else {
					$cond = $option['cond'];
				}
			} else {
				$cond = $this->__getCond($field, $option);
			}

			$parsed[$field] = $cond;
		}

		return $parsed;
	}

/**
 * Przetwarzanie opcji inputa
 * @param type $options
 * @return type
 */
	private function __parseSelectOptions($options) {
		if (is_array($options)) {
			return $options;
		}

		$options = explode(':', $options);

		switch ($options[0]) {
			case 'custom':
				return $this->__customOptions[$options[1]];
				break;
			case 'model':
				return ClassRegistry::init($options[1])->find('list', array('order' => array('name' => 'DESC')));
				break;
			case 'variable':
				return ClassRegistry::init($options[1])->{$options[2]};
				break;
		}
	}

/**
 * Ustawianie danych formularza korzystając z parametrów named 
 */
	private function __setData($options) {
		$this->controller->set('filterOptions', $this->__getInputOptions($options));

		$named = $this->controller->params['named'];

		foreach ($named as $key => $value) {
			$named[$key] = str_replace($this->__slashReplace, '/', $value);
		}
		$this->controller->set('advancedFiltersActive', $this->__getAdvancedIsActive($options));

		unset($named['sort']);
		unset($named['direction']);
		unset($named['limit']);
		unset($named['page']);
		


		$this->controller->data['Filter'] = $named;
//		if ($modelMultiple && !empty($this->controller->params['named'][$modelMultiple]))
//		$this->controller->data[$modelMultiple] = $this->decodeMultipleField($this->controller->params['named'][$modelMultiple]);		
	}

	private function __getAdvancedIsActive($options) {
		$named = $this->controller->params['named'];
		if (empty($options['advanced'])) {
			return false;
		}

		$advancedKeys = array_keys($options['advanced']);
		$selectedKeys = array_keys($named);

		$isActive = (array_intersect($advancedKeys, $selectedKeys));

		return !empty($isActive);
	}

/**
 * Parsowanie pojednyczego warunku według typu
 * @param type $field
 * @param type $options
 * @return boolean 
 */
	private function __getCond($field, $options) {

		$type = $this->__getCondType($field, $options);

		if ($type === false) {
			return false;
		}

		$definedCond = $this->__condTypes[$type];

		$cond = $this->__getRepeatableCond($definedCond, $options);

		if (!$cond) {
			$cond = $this->__getSingularCond($field, $definedCond, $options);
		}

		return $cond;
	}

	private function __getRepeatableCond($definedCond, $options) {
		if (!is_array($options)) {
			return false;
		}

		$operatorOptions = array_intersect_key($options, array('or' => null, 'and' => null));

		if ($operatorOptions) {

			$tags = array(
				'#model#' => $this->__model,
			);

			$operator = current(array_keys($operatorOptions));
			$operatorFields = $operatorOptions[$operator];

			$cond = array();

			foreach ($operatorFields as $operatorField) {
				$tags['#field#'] = $operatorField;
				$cond[$operator][] = $this->recursiveArrayReplace(
						array_keys($tags), array_values($tags), $definedCond
				);
			}

			return $cond;
		}

		return false;
	}

	private function __getSingularCond($field, $definedCond, $options) {
		$modelName = isset($options['model']) ? $options['model'] : $this->__model;
		$fieldName = isset($options['field']) ? $options['field'] : $field;
		$tags = array(
			'#field#' => $fieldName,
			'#model#' => $modelName
		);

		$cond = $this->recursiveArrayReplace(
				array_keys($tags), array_values($tags), $definedCond
		);

		return $cond;
	}

/**
 * Zwraca typ warunku 
 */
	private function __getCondType($field, $options) {
		if (is_string($options)) {
			$type = $options;
		} elseif (isset($options['type'])) {
			$type = $options['type'];
		} else {
			$type = 'equal';
		}

		if (!isset($this->__condTypes[$type])) {
			return false;
		}

		return $type;
	}

/**
 * Funkcja zwaraca listę inputów do zrenderowania w filtrach
 * @param type $options
 * @return type 
 */
	private function __getInputOptions($options) {

		foreach ($options as $type => $typeOptions) {
			foreach ($typeOptions as $field => $option) {

				$optType = $this->__getCondType($field, $option);

				if (!$optType || !isset($this->__defaultOptions[$optType])) {
					$optType = '__empty';
				}

				if ($option !== null && (is_string($option) || !isset($option['opt']))) {

					$defaultOptions = $this->__defaultOptions[$optType];
					if (!is_array($options[$type][$field])) {
						$options[$type][$field] = array('opt' => $defaultOptions);
					} else {
						$options[$type][$field]['opt'] = $defaultOptions;
					}
				}

				if (isset($option['options'])) {

					$options[$type][$field]['opt']['options'] = $this->__parseSelectOptions($option['options']);
					$options[$type][$field]['opt']['empty'] = true;
					$options[$type][$field]['opt']['type'] = 'select';
					unset($options[$type][$field]['options']);
				}
			}
		}

		return $options;
	}

	public function addDataToModelMultiple($model, $modelMultiple) {
		$this->controller->data['Filter'][$modelMultiple] = implode(',', $this->getIdsFromModelMultiple($model, $modelMultiple));
	}

/**
 * Zwraca IDki do filtrowania według selectów, lub checkboxów - z tymi samymi nazwami.
 * @param string $model
 * @param string $modelMultiple
 */
	public function getIdsFromModelMultiple($data, $modelMultiple) {
		$modelMultipleData = array();

		foreach ($data as $group_id) {
			if (!empty($group_id)) {
				if (!is_array($group_id)) {
					$modelMultipleData[] = $group_id;
				} else {
					foreach ($group_id as $g_id) {
						if ($g_id)
							$modelMultipleData[] = $g_id;
					}
				}
			}
		}

		return $modelMultipleData;
	}

	public function encodeMultipleField($data, $multipleModel) {
		$return = array();
		if (empty($data))
			return array();

		if (!empty($data)) {
			foreach ($data as $id => $group) {
				if (is_array($group)) {
					foreach ($group as $group_id) {
						if ($group_id)
							$return[] = $id . ',' . $group_id;
					}
				} else {
					if ($group)
						$return[] = $id . ',' . $group;
				}
			}
		}

		return array($multipleModel => implode(';', $return));
	}

	public function decodeMultipleField($data) {
		$return = array();

		$rows = explode(';', $data);

		foreach ($rows as $row) {
			$cols = explode(',', $row);
			if (!empty($cols[0]) && !empty($cols[1])
			)
				$return[$cols[0]][] = $cols[1];
		}

		return $return;
	}

	public function recursiveArrayReplace($find, $replace, $data) {

		if (is_array($data)) {
			foreach ($data as $key => $value) {
				if (is_array($value)) {
					$data[$key] = $this->recursiveArrayReplace($find, $replace, $data[$key]);
				} else {
					$data[$key] = str_replace($find, $replace, $value);
				}
			}
		} else {
			$data = str_replace($find, $replace, $data);
		}

		return $data;
	}

	public function recursiveArraySearch($haystack, $needle, $partial_matches = false, $search_keys = false) {
		if (!is_array($haystack))
			return false;
		foreach ($haystack as $key => $value) {
			$what = ($search_keys) ? $key : $value;
			if ($needle === $what)
				return $key;
			else if ($partial_matches && @strpos($what, $needle) !== false)
				return $key;
			else if (is_array($value) && $this->recursiveArraySearch($value, $needle, $partial_matches, $search_keys) !== false)
				return $key;
		}
		return false;
	}

	public function _cleanSpaces($data) {
		return $this->recursiveArrayReplace(" ", null, $data);
	}

}