<?php
/**
 * Blokuje panel wymuszając skorzystanie z innej przeglądarki, 
 * do poprawnego działania wymagana jest obecność pliku z widokiem błędu: /app/views/errors/wrong_browser.ctp

 * przykład użycia blokowania dostępu dla domyślnych przeglądarek komponentu:
	var $components = array(
		'PanelDenyBrowsers')
	);

 * przykład użycia blokowania dostępu dla Internet explorer 8 i starszych:
	var $components = array(
		'PanelDenyBrowsers' => array('denyBrowsers' => array('ie' => 8))
	);

 * przykład użycia blokowania dostępu dla wszystkich wersji Internet explorer:
	var $components = array(
		'PanelDenyBrowsers' => array('denyBrowsers' => array('ie'))
	);

 */

class PanelDenyBrowsersComponent extends Object {
	var $components = array("Auth");

	//domyślnie blokowane przeglądarki
	var $denyBrowsers = array(
		'ie' => 6,
		'ff' => 2,
		'opera' => 9
	);
	
	//Pełne nazwy przeglądarek używane w widoku błędu
	var $fullNames = array(
		'ie' => 'Internet Explorer',
		'ff' => 'Firefox',
		'opera' => 'Opera'
	);
	
	//Lista przypisanych funkcji validujących poszczególne przeglądarki
	var $checkFunctions = array(
		'ie' => 'denyMSIE',
		'ff' => 'denyFirefox',
		'opera' => 'denyOpera'
	);
	
	function initialize(&$controller, $settings = array()) {
		$this->controller = &$controller;
		if(!empty($settings['denyBrowsers'])){
			$this->denyBrowsers = $settings['denyBrowsers'];
		}
		$this->browserCheck();
	}
	
	function browserCheck(){
		
		if(!empty($this->controller->params['admin']) && $this->controller->action != 'admin_logout') {
			$authData = $this->Auth->user();
			$denyAccess = false;
			
			$denyInfo = array();
			if(!empty($this->denyBrowsers))
			foreach($this->denyBrowsers as $key => $value){
				if(is_numeric($key)){
					$browser = $value;
					$version = null;
				}
				else{
					$browser = $key;
					$version = $value;
				}
				if(isSet($this->checkFunctions[$browser])){
					if(call_user_func_array(array($this, $this->checkFunctions[$browser]), array('version' => $version))){
						$denyAccess = true;
					}
				}
				else{
					echo 'Błędna wartość '.$browser,' w tablicy denyBrowsers';
				}
				$denyInfo[$browser] = $this->fullNames[$browser];
				if(!empty($version)){
					$denyInfo[$browser] .= ' (wersja '.$version.' i starsze)';
				}
			}
			
			if(!empty($authData) && $denyAccess){
				APP::import('Helper', 'Html'); $html = new HtmlHelper();
				$path = VIEWS.'errors'.DS.'wrong_browser.ctp';
				if(file_exists($path)){
					include($path);
				}
				else{
					echo 'Brak pliku z widokiem błędu: '.$path;
				}
				die;
			}
		}
	}
	
	//funkcja walidująca Internet Explorera
	function denyMSIE($version = array()){
			if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE){
				if(empty($version)){
					return true;
				}
				else{
					$ver = (int)substr($_SERVER['HTTP_USER_AGENT'], strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')+strlen('MSIE')+1, 3);
					if(!empty($ver) && $ver <= $version){
						return true;
					}
					else{
						return false;
					}
				}
			}
			else{
				return false;
			}
	}

	//funkcja walidująca Firefoxa
	function denyFirefox($version = array()){
			if(strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== FALSE){
				if(empty($version)){
					return true;
				}
				else{
					$ver = (int)substr($_SERVER['HTTP_USER_AGENT'], strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox')+strlen('Firefox')+1, 3);
					if(!empty($ver) && $ver <= $version){
						return true;
					}
					else{
						return false;
					}
				}
			}
			else{
				return false;
			}
	}

	//funkcja walidująca Operę
	function denyOpera($version = array()){
			if(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== FALSE){
				if(empty($version)){
					return true;
				}
				else{
					$ver = (int)substr($_SERVER['HTTP_USER_AGENT'], strpos($_SERVER['HTTP_USER_AGENT'], 'Version')+strlen('Version')+1, 3);
					if(!empty($ver) && $ver <= $version){
						return true;
					}
					else{
						return false;
					}
				}
			}
			else{
				return false;
			}
	}


}
?>
