<?php

class LoginHistoryController extends AccountAppController {

	var $name = 'LoginHistory';
	var $components = array('Email', 'Auth', 'Session', 'SavePaginate');

	function admin_index() {
		$this->Config->selectMenu('login_history');
		$conditions = array();
		if (!empty($this->params['named']['user_id'])) {
			$user = $this->LoginHistory->User->find('first', array('recursive' => -1, 'conditions' => array('User.id' => $this->params['named']['user_id'])));
			$conditions = array('LoginHistory.user_id' => $this->params['named']['user_id']);
			if (!empty($user)) $this->set('user', $user);
		}
		
		$this->NewFilter->filter($this->LoginHistory->filterData, 'LoginHistory');
		$this->paginate['LoginHistory']['conditions'][] = $conditions;
		$this->paginate['LoginHistory']['contain'] = array('User' => array('username', 'id','teacher','admin'));
		$this->paginate['LoginHistory']['order'] = 'LoginHistory.created desc';
		$login_history = $this->paginate('LoginHistory');
		$this->set('registersCount', $this->LoginHistory->User->find('count', array('conditions' => array('admin' => 0, 'teacher'=> 0))));
		$this->set('loginCounter', $this->LoginHistory->find('count'));
		$this->set('login_history', $login_history);
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('title_for_layout', 'Historia logowań');
	}

}

