<?php

class ProfilesController extends AccountAppController {

	public $components = array('Filter');
	public $uses = array('Account.User', 'Account.Profile', 'Learning.School');
	public $helpers = array('Js');

	function _dataForRegister() {
		$this->set('schools', $this->School->find('list', array('order' => 'name', 'conditions'=> array('hidden'=> 0))));
		$schoolsJson = $this->School->Classes->find('all');
		$schoolsJson = Set::combine($schoolsJson, '{n}.Classes.id', '{n}.Classes.name', '{n}.Classes.school_id');
		$this->set('schoolsJson', $schoolsJson);
	}

	function register($redirect = null) {
		if (!Configure::read('Site.register'))
			$this->alert('Rejestracja jest obecnie wyłączona!', '/');
		$this->layout = 'login';
		if (!empty($this->data)) {
			unset($this->data['User']['admin']);
			$this->data['User']['username'] = $this->data['Profile']['fname'] . ' ' . $this->data['Profile']['lname'];
			$this->data['User']['activationCode'] = String::uuid();
			if ($this->User->saveAll($this->data, array('validate' => 'first'))) {
				$emailSent = $this->Config->emailSend(
						array(
							'to' => $this->data['User']['email'],
							'subject' => 'Twoje konto zostało założone',
							'template' => 'users_register',
							'data' => array('user' => $this->data)
						)
				);
				if ($emailSent) {
					$this->message('Konto zostało założone.<br />Odbierz wiadomość aktywacyjną aby potwierdzić adres email.', $this->Auth->loginAction);
				} else {
					$this->alert('Konto zostało założone, jednak wiadomość aktywacyjna nie została wysłana. Skontaktuj się z administracją.', $this->Auth->loginAction);
				}
			} else {
				$this->alert('Wystąpił błąd w formularzu');
			}
		}

		$this->set('title_for_layout', 'Rejestracja');
		$this->_dataForRegister();
	}

	/*
	 *  ***** ADMIN PANEL *****
	 */

	public function admin_index() {
		$this->Filter->filter(array(), 'Profile');

		$this->paginate['Profile']['contain'] = array('User', 'School');
		$profiles = $this->paginate('Profile');

		$this->set('profiles', $profiles);
	}

	function admin_edit($id = null) {

		if (!empty($this->data)) {
			$this->User->create($this->data);
			$this->User->id = $this->data['User']['id'];
			if ($this->User->saveAll($this->data)) {
				$this->message('Zmiany zostały zapisane');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
			}
		} else {
			$this->data = $this->User->find('first', array('contain' => array('Profile'), 'conditions' => array('Profile.id' => $id)));
		}
		$schools = $this->School->find('list', array('order' => 'name'));
		$this->set(compact('schools'));
	}

	public function admin_delete($id) {
		if ($this->User->delete($this->Profile->field('user_id', array('id' => $id)))) {
			$this->message('Konto uczestnika zostało usunięte');
		} else
			$this->alert('Nie można było skasować konta uczestnika!');

		$this->redirect(array('action' => 'index'));
	}

	/*
	 * ***** USER PANEL *****
	 */

	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('register');
	}

}