<?php

class UsersController extends AccountAppController {

	var $name = 'Users';
	var $uses = array('Account.User');
	var $components = array('Email', 'Auth', 'Session', 'SavePaginate', 'Account.History');
	var $helpers = array('html', 'form', 'session', 'javascript', 'text');
	var $adminTypes = array(0 => 'user', 1 => 'admin', 2 => 'superadmin');

	function __loginHandler(){
		// logowanie poprzez pesel
		if($this->action != 'login') return;
		if(!empty($this->data['User']['email']) && is_numeric($this->data['User']['email'])) {
			$this->Auth->fields = array('username' => 'pesel', 'password' => 'password');
			$this->data['User']['pesel'] = $this->data['User']['email'];
		}
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->__loginHandler();
		$this->Auth->autoRedirect = false;

		$this->Auth->allow('register', 'remind', 'resetPassword', 'confirm', 'confirmEmail');
	}

	function isAuthorized() {
		return true;
	}

	function confirm($uuid = null) {
		if ($uuid) {
			$user = $this->User->find('first', array('fields' => array('id', 'active'), 'conditions' => array('activationCode' => $uuid)));
			if (!empty($user)) {
				if ($user['User']['active'])
					$this->message('Konto zostało aktywowane wcześniej!', $this->Auth->loginAction);
				$this->User->id = $user['User']['id'];
				if ($this->User->saveField('active', 1)) {
					$this->message('Twoje konto zostało aktywowane!', $this->Auth->loginAction);
				}
			} else
				$this->alert('Błędny kod aktywacyjny');
		} else {
			$this->alert('Błędny kod aktywacyjny');
		}
		$this->redirect($this->Auth->login);
	}

	public function user_edit() {
		if (!empty($this->data)) {
			$this->data['Profile']['id'] = $this->User->Profile->field('id', array('user_id' => $this->Auth->user('id')));
			$type = isset($this->data['User']['type']) ? $this->data['User']['type'] : null;

			if ($type == 'change_password') {
				$this->__changePassword();
				$this->data = $this->User->get($this->Auth->user('id'));
			}

			if ($type == 'change_avatar') {
				$this->data['User']['id'] = $this->Auth->user('id');
				if ($this->User->save($this->data)) {
					$this->message('Dane profilu zostały zapisane');
				} else {
					$this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie!');
				}
			}
		} else {
			$this->data = $this->User->get($this->Auth->user('id'));
		}

		$this->set('avatar', $this->User->field('avatar', array('id' => $this->Auth->user('id'))));
		$this->set('title_for_layout', 'Edytuj profil');
	}

	function __changePassword() {
		$this->data['User']['id'] = $this->Auth->user('id');
		$this->User->validationSet = 'UserChangePassword';
		$this->User->set($this->data);
		if ($this->User->validates()) {
			if ($this->User->savePassword($this->data)) {
				$this->message('Hasło zostało zmienione!');
			} else {
				$this->alert('Wystąpił błąd podczas zmiany hasła!');
			}
		} else {
			$this->alert('Wystąpił błąd w formularzu!');
		}
	}

	public function user_change_password() {

		if (!empty($this->data)) {
			$this->data['User']['id'] = $this->Auth->user('id');
			$this->User->set($this->data);
			if ($this->User->validates()) {
				if ($this->User->savePassword($this->data)) {
					$this->message('Hasło zostało zmienione!', '/');
				} else
					$this->alert('Wystąpił błąd podczas zmiany hasła!');
			} else
				$this->alert('Wystąpił błąd w formularzu!');
		}
	}

	function __sendEmailChangeEmail($data) {
		$this->setEmailSettings($this->Profile->field('new_email', array('id' => $this->Auth->user('id'))), 'Zmiana adresu e-mail Twojego konta w Drukarni Jerzu', 'someone_has_changed_the_email');
		$this->set('data', $data);
		return $this->Email->send();
	}

	function admin_home() {
		$this->Config->selectMenu('home');
	}

	function admin_login() {
		$this->Config->setLayout('admin_panel', 'login');
		if (!empty($this->data)) {
			$this->User->set($this->data);
			$this->User->action = 'login';

			if ($this->User->validates()) {
				$user = $this->Auth->user();
				$this->Auth->login($this->data);
				$this->History->log($this->data, $user);
				if ($user) {
					$this->User->login($user);
					$this->Session->delete('Forum');
					$this->redirect($this->Auth->loginRedirect);
				}
			} else {
				$this->History->log($this->data);
				$this->authMessage('Wystąpił błąd logowania!');
			}
		}
		if ($this->Auth->user()) {
			$this->redirect($this->Auth->redirect());
		}
		$this->set('title_for_layout', 'Zaloguj się');
	}

	function login() {
		$this->layout = 'login';
		if (!empty($this->data)) {

			$this->User->set($this->data);
			$this->User->action = 'login';

			if ($this->User->validates()) {
				$this->Auth->login($this->data);
				$user = $this->Auth->user();
				$this->History->log($this->data, $user);
				if ($user) {
					$this->User->login($user);
					$this->Session->delete('Forum');
					$this->redirect($this->Auth->loginRedirect);
				}
			} else {
				$this->History->log($this->data);
				$errorMessage = '';
				foreach ($this->User->validationErrors as $error) {
					$errorMessage .= ( '<li>' . $error . '</li>');
				}
				$this->Session->setFlash('Wystąpił błąd logowania! <ul>' . $errorMessage . '</ul>', 'default', array('class' => 'alert'), 'auth');
				$this->User->validationErrors = null;
			}
		}
		if ($this->Auth->user()) {
			$this->redirect($this->Auth->redirect());
		}
		$this->set('title_for_layout', 'Zaloguj się');
	}

	function logout() {
		$this->Session->delete('Forum');
		$this->Auth->logout();
		$this->redirect($this->Auth->loginAction);
	}

	function admin_logout() {
		$this->redirect($this->Auth->logout());
	}

	function remind() {
		$this->layout = 'login';
		if (!empty($this->data)) {
			if (empty($this->data['User']['email'])) {
				$this->alert('Wprowadź poprawny adres email!');
			} else {
				$user_id = $this->User->field('id', array('email' => $this->data['User']['email']));
				if (!$user_id) {
					$this->alert('Podany email nie figuruje w bazie danych!');
				} else {
					$this->User->id = $user_id;
					$code = String::uuid();
					if ($this->User->saveField('resetCode', $code)) {
						$emailSent = $this->Config->emailSend(array(
								'to' => $this->data['User']['email'],
								'template' => 'users_remind',
								'subject' => 'Odzyskiwanie hasła',
								'data' => array('code' => $code)
							));

						if ($emailSent) {
							$this->message('Wysłano kod resetujący hasło.', $this->Auth->loginAction);
						} else {
							$this->alert('Nie wysłano kodu resetującego! Skontaktuj się z administracją!');
						}
					} else
						$this->Session->setFlash('Wystąpił błąd', 'default', array('class' => 'alert'));
				}
			}
		}

		$this->set('title_for_layout', 'Przypomnij hasło');
	}

	function resetPassword($uuid = null) {
		if (!$uuid) {
			$this->alert('Brak kodu aktywacyjnego!.', $this->Auth->loginAction);
		}

		$user = $this->User->find('first', array('conditions' => array('resetCode' => $uuid), 'fields' => array('id', 'email'), 'recursive' => -1));
		if (empty($user)) {
			$this->alert('Błędny kod aktywacyjny!', $this->Auth->loginAction);
		}

		$newPassword = $this->_random_password(9, 1);
		$this->User->id = $user['User']['id'];

		if ($this->User->saveField('password', $this->Auth->password($newPassword))) {
			$this->User->saveField('resetCode', null);

			$emailSent = $this->Config->emailSend(array(
					'to' => $user['User']['email'],
					'template' => 'users_reset_password',
					'subject' => 'Odzyskiwanie hasła',
					'data' => array('newPassword' => $newPassword, 'email' => $user['User']['email'])
				));

			if ($emailSent) {
				$this->message('Nowe hasło zostało wysłane na Twój adres e-mail.');
			} else {
				$this->alert('Wystąpił błąd podczas wysyłania wiadomości e-mail.');
			}
		}

		$this->redirect($this->Auth->loginAction);
	}

	function _random_password($length=9, $strength=0) {
		$vowels = 'aeuy';
		$consonants = 'bdghjmnpqrstvz';
		if ($strength & 1) {
			$consonants .= 'BDGHJLMNPQRSTVWXZ';
		}
		if ($strength & 2) {
			$vowels .= "AEUY";
		}
		if ($strength & 4) {
			$consonants .= '23456789';
		}
		if ($strength & 8) {
			$consonants .= '@#$%';
		}

		$password = '';
		$alt = time() % 2;
		for ($i = 0; $i < $length; $i++) {
			if ($alt == 1) {
				$password .= $consonants[(rand() % strlen($consonants))];
				$alt = 0;
			} else {
				$password .= $vowels[(rand() % strlen($vowels))];
				$alt = 1;
			}
		}
		return $password;
	}

	/*
	  function view($alias = null) {
	  if(!$alias){
	  $this->Session->setFlash('Brak użytkownika.','default',array('class'=>'alert'));
	  $this->redirect('/');
	  }
	  if($this->User->find('count',array('recursive'=>-1,'conditions'=>array('alias'=>$alias))) <= 0) {
	  $this->Session->setFlash('Brak użytkownika o podanym aliasie','default',array('class'=>'alert'));
	  $this->redirect('/');
	  }

	  $this->__checkOutsideVisibility($alias);

	  $this->set('breadCrumbs', array(
	  'Profil użytkownika'
	  ));
	  $this->set('alias',$alias);
	  }
	 */

	function admin_add() {
		$this->set('types', $this->adminTypes);

		if (!empty($this->data)) {
			$this->User->create($this->data);

			if ($this->User->validates()) {
				$this->data['User']['active'] = 1;
				if ($this->User->save($this->data)) {
					$this->Session->setFlash('Użytkownik został dodany', 'default', array());
					$this->redirect(array('action' => 'index'));
				} else
					$this->Session->setFlash('Nie można dodać użytkownika', 'default', array('class' => 'alert'));
			}else
				$this->Session->setFlash('Wystąpił błąd w formularzu', 'default', array('class' => 'alert'));
		}
	}

	function setFilterConditions($fieldFilerName, $fieldBaseName) {
		if (isSet($this->data['Filter'][$fieldFilerName])) {
			if ($this->data['Filter'][$fieldFilerName] === '')
				unset($this->paginate['conditions'][$fieldBaseName]);
			else
				$this->paginate['conditions'][$fieldBaseName] = $this->data['Filter'][$fieldFilerName];
		}
	}

	function admin_index() {

		$this->NewFilter->filter($this->User->filterData, 'User');
		
		$this->paginate['User']['conditions'][]= array('User.admin >=' => 1);
		$users = $this->paginate('User');
		$this->set(compact('types', 'users'));


	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->User->saveAll($this->data, array('validate' => 'first'))) {
				$this->message('Zmiany zostały zapisane');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
			}
		} else {
			$this->data = $this->User->find('first', array('conditions' => array('User.id' => $id)));
		}
		$userType = $this->User->field('admin', array('User.id' => $this->data['User']['id']));
		$this->set(compact('userType'));

		$this->set('types', $this->adminTypes);
	}

	function admin_change_password() {
		if (!empty($this->data)) {
			$this->User->create();
			$this->data['User']['id'] = $this->Auth->user('id');
			$this->data['User']['password'] = $this->Auth->password($this->data['User']['new_password']);
			if ($this->User->save($this->data, true, array('old_password', 'new_password', 'rep_password', 'password'))) {
				$this->message('Hasło zostało zmienione');
				$this->redirect(array('controller' => 'users', 'action' => 'panel'));
			} else {
				$this->alert('W formularzu wystąpiły błędy. Poniżej są one dokładnie opisane przy każdym z pól.');
			}
		}
	}

	function admin_password() {
		if (!empty($this->data)) {
			$this->User->create($this->data);

			$this->User->id = $this->Auth->user('id');

			if ($this->User->validates()) {

				if ($this->User->saveField('password', $this->Auth->password($this->data['User']['new1']))) {
					$this->Session->setFlash('Nowe hasło zostało nadane', 'default', array());
					$this->redirect(array('action' => 'index'));
				} else
					$this->Session->setFlash('Nie można zapisać danych', 'default', array('class' => 'alert'));
			}else
				$this->Session->setFlash('Wystąpił błąd w formularzu', 'default', array('class' => 'alert'));
		}
	}

	function admin_delete($id = null) {
		if ($id) {
			if ($this->User->delete($id)) {
				$this->message('Użytkownik został usunięty');
			} else {
				$this->alert('Wystąpił błąd podczas usuwania użytkownika');
			}
		}
		$this->redirect($this->referer());
	}
	
	function admin_logAs($user_id){

		Configure::write('debug',1);
		$user = $this->User->get($user_id);

		$_SESSION['Auth']['User'] = $user['User'];
		$this->redirect('/');
	}
}
