<?php

class Profile extends AccountAppModel {

	var $name = 'Profile';
	var $useTable = 'profiles';
	var $belongsTo = array(
		'User' => array(
			'className' => 'Account.User',
			'foreignKey' => 'user_id'
		),
		'School' => array(
			'className' => 'Learning.School',
			'foreignKey' => 'school_id'
		),
		'Group' => array(
			'className' => 'LearningAccount.Group',
			'foreignKey' => 'group_id'
		),
		'Team' => array(
			'className' => 'LearningAccount.Team',
			'foreignKey' => 'team_id'
		),
		'Classes' => array(
			'className' => 'Learning.Classes',
			'foreignKey' => 'class_id'
		)
	);

	var $validate = array(
		'fname' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		'pesel' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'lname' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);

	var $validateTeacherEdit = array(
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'group_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'team_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	var $validateAdminEdit = array(
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'group_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'team_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	var $validateTeacherActivate = array(
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'group_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'team_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	var $validateAdminActivate = array(
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'group_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'team_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	var $validateChangeAvatar = array(
		'class_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
	);

	function beforeSave() {
		parent::beforeSave();
		if (empty($this->data[$this->name]['name']) && !empty($this->data['Profile']['fname']) && !empty($this->data['Profile']['lname'])) {
			$this->data[$this->name]['name'] = $this->data['Profile']['fname'] . ' ' . $this->data['Profile']['lname'];
		}
		if (!empty($this->data[$this->name]['new_password']))
			$this->data[$this->name]['password'] = Security::hash($this->data[$this->name]['new_password'], false, true);

		return true;
	}

}
