<?php

class User extends AccountAppModel {
	
	var $filterDataStudent = array(
		'basic'=> array(
			'empty'=> null,
			'name'=> array('type'=> 'like','field'=> 'username'),
			'email'=> array('type'=> 'like'),
			'class'=> array('cond'=> array('User.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_classes WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Group', 'field'=> 'name',),	
			'group'=> array('cond'=> array('User.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_groups WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Group', 'field'=> 'name',),	
			'team'=> array('cond'=>array('User.id IN ( SELECT user_id FROM profiles WHERE team_id IN (SELECT id FROM learning_teams WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Team', 'field'=> 'name'),	
			'active_profile'=>array('type' => 'equal','options' => 'custom:yes-no','class' => 'short','model'=> 'Profile','field'=> 'active'),	
			'active_user'=> array('type' => 'equal','options' => 'custom:yes-no','class' => 'short','model'=> 'User','field'=> 'active'),	
			'created'=> array('type'=> 'date_between'),
		)

	);
	
	var $filterDataStudentTeacher = array(
		'basic'=> array(
			'empty'=> null,
			'name'=> array('type'=> 'like'),
			'email'=> array('type'=> 'like'),
			'class'=> array('cond'=> array('User.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_classes WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Group', 'field'=> 'name',),	
			'group'=> array('cond'=> array('User.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_groups WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Group', 'field'=> 'name',),	
			'team'=> array('cond'=>array('User.id IN ( SELECT user_id FROM profiles WHERE team_id IN (SELECT id FROM learning_teams WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Team', 'field'=> 'name'),	
			'active_profile'=>array('type' => 'equal','options' => 'custom:yes-no','class' => 'short','model'=> 'Profile','field'=> 'active'),	
			'created'=> array('type'=> 'date_between'),
		)

	);	
	
	var $filterData = array(
		'basic'=> array(
			'username'=> array('type'=> 'like'),
			'email'=> array('type'=> 'like'),
			'created'=> array('type'=> 'date_between'),
		)

	);
	
	var $name = 'User';
	var $useTable = 'account_users';
	var $hasMany = array(
		'Topic' => array(
			'className' => 'Forum.Topic',
			'foreignKey' => 'user_id',
			'dependent' => true,
			'exclusive' => true
		),
		'Post' => array(
			'className' => 'Forum.Post',
			'dependent' => true,
			'exclusive' => true,
			'foreignKey' => 'user_id',
		),
		'Moderator' => array(
			'className' => 'Forum.Moderator',
			'dependent' => true,
			'foreignKey' => 'user_id',
			'exclusive' => true
		),
		'Access' => array(
			'className' => 'Forum.Access',
			'dependent' => true,
			'foreignKey' => 'user_id',
			'exclusive' => true
		),
		'Answer'=> array(
			'className' => 'Learning.Answer',
			'dependent' => true,
			'foreignKey'=> 'student_id'
		),
		'AnswerGrade'=> array(
			'className' => 'Learning.AnswerGrade',
			'dependent'=> true,
			'foreignKey'=> 'author_id'
		),
		'Grade'=> array(
			'className' => 'Learning.Grade',
			'dependent'=> true,
			'foreignKey'=> 'student_id'
		)
	);
	/**
	 * Constants specific to changing the status of a user.
	 *
	 * @access public
	 * @var string
	 */
	const STATUS_BANNED = 1;
	const STATUS_ACTIVE = 0;

	public $validateEdit = array(
		'username' => array(
			'isUnique' => array(
				'rule' => 'isUnique',
				'message' => 'That username has already been taken',
				'on' => 'create'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter a username'
			)
		),
		'password' => array(
			'rule' => 'notEmpty',
			'message' => 'Please enter a password'
		),
		'oldPassword' => array(
			'rule' => array('isPassword'),
			'message' => 'The old password did not match'
		),
		'newPassword' => array(
			'isMatch' => array(
				'rule' => array('isMatch', 'confirmPassword'),
				'message' => 'The passwords did not match'
			),
			'custom' => array(
				'rule' => array('custom', '/^[-_a-zA-Z0-9]+$/'),
				'message' => 'Your password may only be alphanumeric'
			),
			'between' => array(
				'rule' => array('between', 6, 20),
				'message' => 'Your password must be 6-20 characters in length'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Please enter a password'
			)
		),
		'email' => array(
			'isUnique' => array(
				'rule' => 'isUnique',
				'message' => 'That email has already been taken',
				'on' => 'create'
			),
			'email' => array(
				'rule' => array('email', true),
				'message' => 'Your email is invalid'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Your email is required'
			)
		)
	);
	var $validateLogin = array(
		'email' => array(
			array(
				'rule' => array('studentActive'),
				'message' => 'Konto nie zostało zatwierdzone przez nauczyciela!'
			),
			array(
				'rule' => array('userActive'),
				'message' => 'Konto nie jest aktywne! Jeśli nie otrzymałeś wiadomości aktywacyjnej skontaktuj się z administracją!'
			),
			array(
				'rule' => array('notEmpty', true),
				'message' => 'Podaj prawidłowy adres email lub PESEL'
			),
		),
	);

	function userActive($email) {
		$email = array_pop($email);
		if(!$email) return false;

		if(is_numeric($email)) $conditions = array('pesel'=> $email);
		else $conditions = array('email'=> $email);

		$user = $this->get( $conditions );
		if (!$user)
			return true;
		return $user['User']['active'] != 0;
	}

	function studentActive($email) {
		$email = array_pop($email);
		if(!$email) return false;

		if(is_numeric($email)) $conditions = array('pesel'=> $email);
		else $conditions = array('email'=> $email);

		$profile = $this->Profile->get(array('user_id' => $this->field('id', $conditions )));
		if (!$profile)
			return true;
		return $profile['Profile']['active'] != 0;
	}

	var $actsAs = array(
		'Upload' => array(
			'avatar' => array(
				'dir' => 'uploaded{DS}{ModelName}{DS}{fieldName}',
				'create_directory' => true,
				'allowedMime' => false,
				'allowedExt' => array('.jpg', '.jpeg', '.png', '.gif'),
				'filesize' => 'filesize',
				'mimetype' => 'url_mimetype',
				'thumbsizes' => array(
					'small' => array('width' => 100, 'height' => 100, 'zoomCrop' => 'C', 'zc' => 'C', 'zoom_crop' => 'C'),
				),
				'imageMagickPath' => false,
				'validations' => array(
					'Empty' => array(
						'rule' => array('uploadCheckEmpty'),
						'check' => false,
						'on' => 'create',
						'last' => true
					),
				)
		)));
	/**
	 * Table prefix.
	 *
	 * @access public
	 * @var string
	 */
	public $tablePrefix = '';
	public $columnMap = array(
		'status' => 'status',
		'signature' => 'signature',
		'locale' => 'locale', // Must allow 3 characters: eng
		'timezone' => 'timezone', // Must allow 5 digits: -10.5
		'totalPosts' => 'totalPosts',
		'totalTopics' => 'totalTopics',
		'currentLogin' => 'currentLogin',
		'lastLogin' => 'lastLogin'
	);

	public function forgotRetrieval($data) {
		$user = $this->find('first', array(
				'conditions' => array(
					'OR' => array(
						array('User.email' => $data['User']['email']),
						array('User.username' => $data['User']['username'])
					)
				)
			));

		if (empty($user)) {
			$this->invalidate('username', 'No user was found with either of those credentials');
			return false;
		}

		return $user;
	}

	/**
	 * Get a users profile: info, access levels, moderations.
	 *
	 * @access public
	 * @param int $id
	 * @return array
	 */
	public function getProfile($id) {
		return $this->find('first', array(
			'conditions' => array('User.id' => $id),
			'contain' => array(
				'Access' => array('AccessLevel'),
				'Moderator' => array('ForumCategory')
			)
		));
	}

	/**
	 * Get the latest users signed up.
	 *
	 * @access public
	 * @param $limit
	 * @return array
	 */
	public function getLatest($limit = 10) {
		return $this->find('all', array(
			'limit' => $limit,
			'order' => 'User.created DESC'
		));
	}

	/**
	 * Get the newest signup.
	 *
	 * @access public
	 * @return array
	 */
	public function getNewestUser() {
		return $this->find('first', array(
			'fields' => array('User.id', 'User.username'),
			'order' => 'User.created DESC',
			'limit' => 1
		));
	}

	public function decreasePosts($id) {
		return $this->query("UPDATE `account_users` AS `User` SET `User`.`" . $this->columnMap['totalPosts'] . "` = `User`.`" . $this->columnMap['totalPosts'] . "` - 1 WHERE `User`.`id` = $id");
	}

	/**
	 * Increase the post count.
	 *
	 * @access public
	 * @param int $id
	 * @return boolean
	 */
	public function increasePosts($id) {
		return $this->query("UPDATE `account_users` AS `User` SET `User`.`" . $this->columnMap['totalPosts'] . "` = `User`.`" . $this->columnMap['totalPosts'] . "` + 1 WHERE `User`.`id` = $id");
	}

	/**
	 * Increase the topic count.
	 *
	 * @access public
	 * @param int $id
	 * @return boolean
	 */
	public function decreaseTopics($id) {
		return $this->query("UPDATE `account_users` AS `User` SET `User`.`" . $this->columnMap['totalTopics'] . "` = `User`.`" . $this->columnMap['totalTopics'] . "` - 1 WHERE `User`.`id` = $id");
	}

	/**
	 * Increase the topic count.
	 *
	 * @access public
	 * @param int $id
	 * @return boolean
	 */
	public function increaseTopics($id) {
		return $this->query("UPDATE `account_users` AS `User` SET `User`.`" . $this->columnMap['totalTopics'] . "` = `User`.`" . $this->columnMap['totalTopics'] . "` + 1 WHERE `User`.`id` = $id");
	}

	/**
	 * Checks to see if the old password matches their input.
	 *
	 * @access public
	 * @param array $data
	 * @return boolean
	 */
	public function isPassword($data) {
		$user = $this->find('first', array(
				'conditions' => array('User.id' => $_SESSION['Auth']['User']['id']),
				'fields' => array('User.password'),
				'contain' => false
			));

		$data = array_values($data);

		$var1 = Security::hash($data[0], 'sha1', true);
		$var2 = $user['User']['password'];

		return ($var1 === $var2);
	}

	/**
	 * Login the user and update records.
	 *
	 * @access public
	 * @param array $user
	 * @return boolean
	 */
	public function login($user) {

		if (!empty($user)) {
			$data = array();
			$data[$this->columnMap['currentLogin']] = date('Y-m-d H:i:s');
			$data[$this->columnMap['lastLogin']] = $user['User']['currentLogin'];

			$this->id = $user['User']['id'];
			return $this->save($data, false, array_keys($data));
		}

		return true;
	}

	/**
	 * Change the users password.
	 *
	 * @access public
	 * @param int $id
	 * @param string $password
	 * @return boolean
	 */
	public function resetPassword($id, $password) {
		$this->id = $id;
		return $this->saveField('password', $password);
	}

	/**
	 * Get whos online within the past x minutes.
	 *
	 * @access public
	 * @param int $minutes
	 * @return array
	 */
	public function whosOnline($minutes) {
		$past = date('Y-m-d H:i:s', strtotime('-' . $minutes . ' minutes'));

		return $this->find('all', array(
			'conditions' => array('User.' . $this->columnMap['currentLogin'] . ' >' => $past),
			'fields' => array('User.id', 'User.username'),
			'contain' => false
		));
	}

	public function saveResetCode($email) {
		$user_id = $this->field('id', array('email' => $email));
		return $user_id ? $this->update($user_id, array('resetCode' => String::uuid())) : false;
	}

	public function savePassword($data) {
		$this->id = $_SESSION['Auth']['User']['id'];
		$newPassword = Security::hash($data['User']['newPassword'], null, true);
		return $this->saveField('password', $newPassword);
	}

	public function _newPassword($uuid = null) {
		$return = array();

		$user = $this->find('first', array('conditions' => array('resetCode' => $uuid), 'fields' => array('id', 'email')));
		if (empty($user))
			return false;


		$newPassword = $this->generate();
		$return['newPassword'] = $newPassword;
		$return['email'] = $user['User']['email'];

		$this->id = $user['User']['id'];
		if ($this->saveField('password', Security::hash($newPassword, null, true)) && $this->saveField('resetCode', null))
			return $return;

		return false;
	}

	/**
	 * Generates a string of random characters.
	 *
	 * @access public
	 * @param int $length
	 * @return string
	 */
	public function generate($length = 10) {
		$characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$return = '';

		if ($length > 0) {
			$totalChars = mb_strlen($characters) - 1;
			for ($i = 0; $i <= $length; ++$i) {
				$return .= $characters[rand(0, $totalChars)];
			}
		}

		return $return;
	}

	public function beforeValidate() {
		$action = (isset($this->action) ? $this->action : null);

		if ($action == 'login') {

			if (
				empty(
					$_POST['data']['User']['password']) ||
				!$this->checkField(array('email' => $this->data[$this->name]['email']), 'password', Security::hash($_POST['data']['User']['password'], null, true)
			)) {

				unset($this->validate['email']['banned']);
				unset($this->validate['email']['active']);
			}

			$this->data[$this->name]['password'] = $_POST['data']['User']['password'];
		} else if ($action == 'register') {
			$this->validate['security'] = array(
				'equalTo' => array(
					'rule' => array('equalTo', Configure::read('ForumSettings.security_answer')),
					'message' => 'Odpowiedź jest niepoprawna! Spróbuj ponownie!'
				),
				'notEmpty' => array(
					'rule' => 'notEmpty',
					'message' => 'Odpowiedź jest wymagana'
				),
				'required' => true
			);
		}
		if (!empty($this->data[$this->name]['password']) && $this->data[$this->name]['password'] == Security::hash('', false, true))
			$this->data[$this->name]['password'] = null;

		return true;
	}

	/*
	 * Sprawdza czy podane pole ma podaną wartość, lub czy pole o podanych danych istnieje w bazie (jesli nie przekaże sie parametru value)
	 */

	public function checkField($data, $field, $value = false) {

		if ($value !== false) {
			return $this->field($field, $data) == $value;
		} else {
			return $this->field($field, $data) != null;
		}
	}

	var $hasOne = array(
		'Profile' => array(
			'className' => 'Account.Profile',
			'foreignKey' => 'user_id',
			'dependent' => true
		)
	);
	var $validateUserChangePassword = array(
		'password' => array(
			'rule' => 'notEmpty',
			'message' => 'Wprowadź hasło'
		),
		'oldPassword' => array(
			array(
				'rule' => array('isPassword'),
				'message' => 'Stare hasło nie jest poprawne'
			),
			array(
				'rule' => 'notEmpty',
				'message' => 'Wprowadź hasło'
			),
		),
		'newPassword' => array(
			'isMatch' => array(
				'rule' => array('isMatch', 'confirmPassword'),
				'message' => 'Hasła się nie zgadzają'
			),
			'between' => array(
				'rule' => array('between', 6, 20),
				'message' => 'Hasło musi mieć minimalną długość 6 znaków, a maksymalną 20'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Wprowadź hasło'
			)
		),
		'confirmPassword' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Wprowadź hasło'
			)
		)
	);
	public $validateAdminAdd = array(
		'email' => array(
			array('rule' => 'isUnique', 'message' => 'Ten adres e-mail jest zajęty', 'required' => true),
			array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		),
		'password' => array(
			array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
			array('rule' => 'retypeField', 'message' => 'Podane hasła się nie zgadzają'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
		),
		'retype_password' => array(
			array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
		),
	);
	public $validateAdminEdit = array(
		'email' => array(
			array('rule' => 'isUnique', 'message' => 'Ta adres e-mail należy już do innego użytkownika', 'required' => true),
			array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		),
	);

	function retypeField($field = null) {
		$field = end(array_keys($field));

		if (strpos($field, 'retype') !== false) {
			$field = str_replace('retype_', null, $field);
			if ($this->data[$this->name][$field] === Security::hash(null, false, true) || $this->data[$this->name][$field] == null)
				return true;
			return $this->data[$this->name][$field] == $this->data[$this->name]['retype_' . $field];
		}

		return $this->data[$this->name][$field] === Security::hash($this->data[$this->name]['retype_' . $field], false, true);
	}

	function retypeField2($field = null) {
		$field = end(array_keys($field));

		if (strpos($field, 'retype') !== false) {
			$field = str_replace('retype_', null, $field);

			return $this->data[$this->name][$field] == $this->data[$this->name]['retype_' . $field];
		}

		return $this->data[$this->name][$field] === $this->data[$this->name]['retype_' . $field];
	}

	var $validateRegister =
		array(
		//'accept' => array('rule' => 'checkAccept', 'message' => 'Aby zarejestrować nowe konto, wymagana jest akceptacja regulaminu.', 'required' => true),
		'email' => array(
			array('rule' => 'isUnique', 'message' => 'Ten adres e-mail należy już do innego użytkownika', 'required' => true),
			array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		),
		'retype_email' => array(
			array('rule' => array('isMatch','email'), 'message' => 'Adresy e-mail się nie zgadzają'),
			array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
		),			
		'password' => array(
			array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
			array('rule' => 'retypeField', 'message' => 'Podane hasła się nie zgadzają'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
		),
		'retype_password' => array(
			array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
		),
	);
	var $validateEditPassword = array(
		'password' => array(
			array('rule' => 'checkActualPassword', 'message' => 'Niepoprawne hasło'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
		),
		'new_password' => array(
			array('rule' => 'retype', 'message' => 'Powtórzone hasła się nie zgadzają'),
			array(
				'rule' => array('maxLength', '40'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków',
				'required' => true
			),
			array(
				'rule' => array('minLength', '6'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków',
				'required' => true
			),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
		),
		'retype_new_password' => array(
			array('rule' => 'retype', 'message' => 'Powtórzone hasła się nie zgadzają'),
			array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
		)
	);

	function checkActualPassword($params) {
		$actualPassword = $this->field('password');

		return Security::hash($params['password'], false, true) == $actualPassword;
	}

	function retype($params) {

		return $this->data[$this->name]['new_password'] == $this->data[$this->name]['retype_new_password'];
	}

	var $validateAdminChangePassword = array(
		'new_password' => array(
			'maxLength' => array(
				'rule' => array('maxLength', '40'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
			),
			'minLength' => array(
				'rule' => array('minLength', '6'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Pole jest wymagane'
			),
		),
		'old_password' => array(
			'check_old_password' => array(
				'rule' => array('check_old_password'),
				'required' => true,
				'message' => 'Niepoprawne hasło'
			),
			'notempty' => array(
				'rule' => 'notempty',
				'required' => true,
				'message' => 'Pole jest wymagane',
			)
		),
		'rep_password' => array(
			'fieldsEqualTo' => array(
				'rule' => array('isMatch', 'new_password', 'rep_password'),
				'required' => true,
				'message' => 'Błędnie powtórzono nowe hasło',
			),
			'notempty' => array(
				'rule' => 'notempty',
				'required' => true,
				'message' => 'Pole jest wymagane',
			)
		),
	);
	var $validateTeacherChangePassword = array(
		'new_password' => array(
			'maxLength' => array(
				'rule' => array('maxLength', '40'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
			),
			'minLength' => array(
				'rule' => array('minLength', '6'),
				'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
				'message' => 'Pole jest wymagane'
			),
		),
		'old_password' => array(
			'check_old_password' => array(
				'rule' => array('check_old_password'),
				'required' => true,
				'message' => 'Niepoprawne hasło'
			),
			'notempty' => array(
				'rule' => 'notempty',
				'required' => true,
				'message' => 'Pole jest wymagane',
			)
		),
		'rep_password' => array(
			'fieldsEqualTo' => array(
				'rule' => array('isMatch', 'new_password', 'rep_password'),
				'required' => true,
				'message' => 'Błędnie powtórzono nowe hasło',
			),
			'notempty' => array(
				'rule' => 'notempty',
				'required' => true,
				'message' => 'Pole jest wymagane',
			)
		),
	);

	function check_old_password($data) {
		$valid = false;
		$data['old_password'] = Security::hash(Configure::read('Security.salt') . $data['old_password']);
		$password = $this->field('password', $this->name . '.id = "' . $this->id . '"');
		if ($data['old_password'] == $password && !empty($data['old_password'])) {
			$valid = true;
		}
		return $valid;
	}

	function checkNewPass() {
		return $this->data[$this->name]['new1'] == $this->data[$this->name]['new2'];
	}

	function checkActualPass() {

		return Security::hash($this->data[$this->name]['password'], false, true) == $this->field('password', array('id' => $this->id));
	}

	function checkAccept() {
		return ($this->data[$this->name]['accept'] != 0);
	}

	function checkReason($params) {
		return (array_key_exists($params['reason'], $this->reason));
	}

	function beforeSave() {
		parent::beforeSave();
		if (!empty($this->data['Profile']['fname']) && !empty($this->data['Profile']['lname'])) {
			$this->data[$this->name]['username'] = $this->data['Profile']['fname'] . ' ' . $this->data['Profile']['lname'];
		}
		if (!empty($this->data[$this->name]['new_password']))
			$this->data[$this->name]['password'] = Security::hash($this->data[$this->name]['new_password'], false, true);

		return true;
	}

	function checkPass() {
		//return $this->data[$this->name]['password'] == $this->data[$this->name]['password2'];
		//debug(Security::hash($this->data[$this->name]['password2'], null, true));
		return $this->data[$this->name]['password'] == Security::hash($this->data[$this->name]['password2'], null, true);
	}

	function checkCaptcha($params) {
		return($params['captcha'] == $this->captcha);
	}

	function checkEmail() {
		return $this->data[$this->name]['email'] == $this->data[$this->name]['emailz'];
	}

}
