<?php

class ContactsController extends ContactAppController {
	var $name = 'Contacts';
	var $components = array('Email');

	var $uses = array('Contact.Contact');
	var $helpers = array('Javascript');

	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('*');
		$this->set('title_for_layout', 'Kontakt');
		$this->Security->validatePost = false;
	}

	function kontakt(){
		if(!empty($this->data)) {
				
			$this->Contact->create($this->data);
			if($this->Contact->validates()) {
				$this->_sendEmail($this->data,Configure::read('Email.to'),'kontakt',$this->data['Contact']['subject'],$this->data['Contact']['email']);
			} else $this->alert('Wystąpił błąd w formularzu.');
		}
	}

	function _addEmail($address = null) {
		if (!empty($address)) {
			$data = array('Mail'=>array('address'=>$address));
			$this->Mail->create($data);
				
			if($this->Mail->validates()) {

				$data['Mail']['activation_code'] = String::uuid();
				$data['Mail']['remove_code'] = String::uuid();

				if ($this->Mail->save($data)) {
					if($this->_sendActivation($data['Mail'])) {
						$this->data = null;
					}
				}
			}

		}
		return;
	}

	function _sendActivation($data) {

		$this->Email->reset();
		//$this->Email->delivery = 'smtp';
		$this->Email->to = $data['address'];
		$this->Email->subject = 'Aktywacja adresu email';

		$this->Email->template = 'emails_add';
		$this->Email->sendAs = 'html';
		$this->set('data',$data);
		return $this->Email->send();

	}

	function _sendEmail($data = null,$to=null,$template=null,$subject=null,$replyTo=null){
		$limit = 30;

		if(!$data || !$to || !$template || !$subject) {
			$this->Session->setFlash('Wystąpił błąd w danych wejściowych.','default',array('class'=>'alert'));
			return false;
		}

		if($this->Session->read('Contact.'.$template.'.sendTime')){
			$secondsAgo = time() - $this->Session->read('Contact.'.$template.'.sendTime');
			if($secondsAgo < $limit) {
				$this->Session->setFlash('Aby wysłać kolejną wiadomość zaczekaj '.($limit-$secondsAgo).' sekund.','default',array('class'=>'alert'));
				return false;
			}
		}


		$this->Email->to = $to;
		if(Configure::read('Email.contact_bcc')) $this->Email->cc = explode(';', Configure::read('Email.contact_bcc') );
		$this->Email->subject = $subject;
		if($replyTo) $this->Email->replyTo = $replyTo;
		if($replyTo) $this->Email->from = Configure::read('Site.name').' <'.  $replyTo. '>';
		$this->Email->template = $template;

		$this->set('data', $data);

		if($this->Email->send()) {
			$this->Session->setFlash('Wiadomość została wysłana.','default',array());
			$this->data = null;
			$this->Session->write('Contact.'.$template.'.sendTime',time());
		} else {
			$this->Session->setFlash('Wystąpił błąd podczas wysyłania wiadomości.','default',array('class'=>'alert'));
		}

		return;

	}

}

