<?php 

class Files extends ContentAppModel {
	
	var $name = 'Files';
	var $useTable = 'news_files';

	var $actsAs = array('Move'=>array('group'=>'news_id'));

	function storeFolder($web = false){
		if(!$web) return '..'.DS.'webroot'.DS.'upload'.DS.'news_files'.DS;
		else return '/upload/news_files/';
	}
	
	function beforeSave(){

		if(!empty($this->data[$this->name]['file']['tmp_name']) && is_uploaded_file($this->data[$this->name]['file']['tmp_name'])) {
			$this->data[$this->name]['url'] = $this->_uploadFile($this->data[$this->name]['file'],$this->storeFolder());
			if(empty($this->data[$this->name]['url'])) return false;

			$this->data[$this->name]['type'] = $this->data[$this->name]['file']['type'];
			$this->data[$this->name]['size'] = $this->data[$this->name]['file']['size'];
		}
		return true;
	}

		
	function saveFiles($data,$id){
		$saved = true;
		foreach ($data['files'] as $file) {

			if(!empty($file['tmp_name'])) {
				$dataToSave['Files']['news_id'] = $id;
				if(!empty($file['title'])) $dataToSave['Files']['title'] = $file['title'];
				$dataToSave['Files']['file'] = $file;
				$this->create();
				$this->id = null;
				if(!$this->save($dataToSave) && $saved) {
					$saved = false;
				}
			}
		}
		
		return $saved;
	}
	
	function beforeDelete(){
		if($this->id) $this->file = $this->field('url',array('id'=>$this->id));
		return true;
	}
	
	function afterDelete(){
		if(!empty($this->file)) unlink($this->storeFolder().$this->file);
	}
	
	function _checkStructure(){
		if(!file_exists($this->storeFolder())) {
			mkdir($this->storeFolder());
		} 
		
		return;
	}
	
	var $validate = array(
		'title'=>array('rule'=>'notEmpty','message'=>'Pole nie może być puste'),
		'file'=>array('rule'=>array('extension',array('gif','jpg','jpeg','pdf','doc','docx','odt','xls','txt','zip','rar')),'message'=>'Niepoprawne rozszerzenie')
	);
}

?>