<?php

class GalleryPicture extends ContentAppModel {
     var $name = 'GalleryPicture';
     var $useTable = 'content_gallery_pictures';

     var $belongsTo = array(
	 'Gallery'=> array('className'=> 'Content.Gallery', 'foreignKey'=> 'foreign_id')
     );

     var $validate = array(
	 'title'=> array('message'=> 'Pole nie może być puste', 'rule'=> 'notEmpty')
     );

     var $actsAs = array(
	 'Move'=>array('group'=>'foreign_id'),
	 'Upload' => array(
	     'file' => array(
		 'dir' => 'uploaded{DS}{ModelName}{DS}{fieldName}',
		 'create_directory' => true,
		 'allowedMime' => array('image/jpeg', 'image/pjpeg', 'image/gif', 'image/png'),
		 'allowedExt' => array('.jpg', '.jpeg', '.png', '.gif'),
		 'filesize' => 'filesize',
		 'mimetype' => 'url_mimetype',
		 'thumbsizes' => array(
		     'small' => array('width' => 115, 'height' => 115),
		     'medium' => array('width' =>220, 'height' => 220),
		     'large' => array('width' => 800, 'height' => 600)
		 ),
		 'imageMagickPath' => false
	 )));


}