<?php

/**
 * Cupcake - Home Controller
 *
 * @author 		Miles Johnson - www.milesj.me
 * @copyright	Copyright 2006-2009, Miles Johnson, Inc.
 * @license 	http://www.opensource.org/licenses/mit-license.php - Licensed under The MIT License
 * @link		www.milesj.me/resources/script/forum-plugin
 */
class HomeController extends ForumAppController {

     /**
      * Models.
      *
      * @access public
      * @var array
      */
     public $uses = array('Forum.Topic');

     /**
      * Forum index.
      *
      * @access public   
      */
     public function index() {
	  $this->ForumToolbar->pageTitle(__d('forum', 'Index', true));
	  $this->set('menuTab', 'home');
	  $this->set('forums', $this->Topic->ForumCategory->Forum->getIndex($this->ForumToolbar->getAccess(), $this->Session->read('Forum.access')));
	  $this->set('totalPosts', $this->Topic->Post->find('count', array('contain' => false)));
	  $this->set('totalTopics', $this->Topic->find('count', array('contain' => false)));
	  $this->set('totalUsers', $this->Topic->User->find('count', array('contain' => false)));
	  $this->set('newestUser', $this->Topic->User->getNewestUser());
	  $this->set('whosOnline', $this->Topic->User->whosOnline($this->ForumToolbar->settings['whos_online_interval']));
     }

     /**
      * RSS Feed.
      *
      * @access public
      */
     public function feed() {
	  if ($this->RequestHandler->isRss()) {
	       $this->set('items', $this->Topic->getLatest());
	       $this->set('document', array('xmlns:dc' => 'http://purl.org/dc/elements/1.1/'));
	  } else {
	       $this->redirect('/forum/home/feed.rss');
	  }
     }

     /**
      * Help / FAQ.
      *
      * @access public
      */
     public function help() {
	  $this->ForumToolbar->pageTitle(__d('forum', 'Help', true));
	  $this->set('menuTab', 'help');
     }

     /**
      * Rules.
      *
      * @access public
      */
     public function rules() {
	  $this->ForumToolbar->pageTitle(__d('forum', 'Rules', true));
	  $this->set('menuTab', 'rules');
     }

     /**
      * Administration home, list statistics.
      *
      * @access public
      * @category Admin
      */
     public function admin_index() {
	  $this->loadModel('Forum.Report');
	  $this->loadModel('Forum.Moderator');

	  $this->set('title_for_layout', __d('forum', 'Administration', true) );
	  $this->set('menuTab', 'home');
	  $this->set('totalPosts', $this->Topic->Post->find('count', array('contain' => false)));
	  $this->set('totalTopics', $this->Topic->find('count', array('contain' => false)));
	  $this->set('totalUsers', $this->Topic->User->find('count', array('contain' => false)));
	  $this->set('totalPolls', $this->Topic->Poll->find('count', array('contain' => false)));
	  $this->set('totalReports', $this->Report->find('count', array('contain' => false)));
	  $this->set('totalMods', $this->Moderator->find('count', array('contain' => false)));
	  $this->set('newestUser', $this->Topic->User->getNewestUser());
	  $this->set('latestReports', $this->Report->getLatest());
	  $this->set('latestUsers', $this->Topic->User->getLatest());
     }

     function admin_localize($lang = false) {
	  if (!$lang)
	       $lang = Configure::read('Config.language');
	  $this->set('menuTab', 'settings');
	  $fileUrl = APP . 'plugins' . DS . 'forum' . DS . 'locale' . DS . $lang . DS . 'LC_MESSAGES' . DS . 'forum.po';

	  if (file_exists($fileUrl)) {
	       $uchwyt = @fopen($fileUrl, "r");

	       if (!empty($this->data)) {

		    // zapisz plik
		    $fileToSave = "";
		    foreach ($this->data['Lang'] as $data) {
			 $msgid = $data['msgid'];
			 $msgstr = $data['msgstr'];
			 $fileToSave .= "msgid \"$msgid\"\nmsgstr \"$msgstr\"\n\n";
		    }

		    if (!empty($fileToSave)) {
			 if (file_put_contents($fileUrl, $fileToSave)) {
			      @unlink(APP . 'tmp' . DS . 'cache' . DS . 'persistent' . DS . 'cake_core_default_' . $lang);
			      $this->message('Plik językowy został zapisany');
			 } else {
			      $this->alert('Plik językowy nie został zapisany');
			 }
		    }
	       }
	       if (empty($file))
		    $file = $this->__loadPo($uchwyt);
	       $this->set(compact('code', 'file'));
	  } else {
	       $this->Session->setFlash('Wystąpił błąd! Nie można odnaleźć na serwerze pliku <' . $fileUrl . '>', 'default', array('class' => 'alert'));
	       $this->redirect($this->referer());
	  }
     }

     function __loadPo($file) {

	  $type = 0;
	  $translations = array();
	  $translationKey = "";
	  $plural = 0;
	  $header = "";

	  do {
	       $line = trim(fgets($file, 1024));
	       if ($line == "" || $line[0] == "#") {
		    continue;
	       }
	       if (preg_match("/msgid[[:space:]]+\"(.+)\"$/i", $line, $regs)) {
		    $type = 1;
		    $translationKey = stripcslashes($regs[1]);
	       } elseif (preg_match("/msgid[[:space:]]+\"\"$/i", $line, $regs)) {
		    $type = 2;
		    $translationKey = "";
	       } elseif (preg_match("/^\"(.*)\"$/i", $line, $regs) && ($type == 1 || $type == 2 || $type == 3)) {
		    $type = 3;
		    $translationKey .= stripcslashes($regs[1]);
	       } elseif (preg_match("/msgstr[[:space:]]+\"(.+)\"$/i", $line, $regs) && ($type == 1 || $type == 3) && $translationKey) {
		    $translations[$translationKey] = stripcslashes($regs[1]);
		    $type = 4;
	       } elseif (preg_match("/msgstr[[:space:]]+\"\"$/i", $line, $regs) && ($type == 1 || $type == 3) && $translationKey) {
		    $type = 4;
		    $translations[$translationKey] = "";
	       } elseif (preg_match("/^\"(.*)\"$/i", $line, $regs) && $type == 4 && $translationKey) {
		    $translations[$translationKey] .= stripcslashes($regs[1]);
	       } elseif (preg_match("/msgid_plural[[:space:]]+\".*\"$/i", $line, $regs)) {
		    $type = 6;
	       } elseif (preg_match("/^\"(.*)\"$/i", $line, $regs) && $type == 6 && $translationKey) {
		    $type = 6;
	       } elseif (preg_match("/msgstr\[(\d+)\][[:space:]]+\"(.+)\"$/i", $line, $regs) && ($type == 6 || $type == 7) && $translationKey) {
		    $plural = $regs[1];
		    $translations[$translationKey][$plural] = stripcslashes($regs[2]);
		    $type = 7;
	       } elseif (preg_match("/msgstr\[(\d+)\][[:space:]]+\"\"$/i", $line, $regs) && ($type == 6 || $type == 7) && $translationKey) {
		    $plural = $regs[1];
		    $translations[$translationKey][$plural] = "";
		    $type = 7;
	       } elseif (preg_match("/^\"(.*)\"$/i", $line, $regs) && $type == 7 && $translationKey) {
		    $translations[$translationKey][$plural] .= stripcslashes($regs[1]);
	       } elseif (preg_match("/msgstr[[:space:]]+\"(.+)\"$/i", $line, $regs) && $type == 2 && !$translationKey) {
		    $header .= stripcslashes($regs[1]);
		    $type = 5;
	       } elseif (preg_match("/msgstr[[:space:]]+\"\"$/i", $line, $regs) && !$translationKey) {
		    $header = "";
		    $type = 5;
	       } elseif (preg_match("/^\"(.*)\"$/i", $line, $regs) && $type == 5) {
		    $header .= stripcslashes($regs[1]);
	       } else {
		    unset($translations[$translationKey]);
		    $type = 0;
		    $translationKey = "";
		    $plural = 0;
	       }
	  } while (!feof($file));
	  fclose($file);
	  $merge[""] = $header;
	  return array_merge($merge, $translations);
     }

     /**
      * Edit the settings.
      *
      * @access public
      * @category Admin
      */
     public function admin_settings() {
	  $this->loadModel('Forum.ForumSetting');

	  // Form Processing
	  if (!empty($this->data)) {
	       $this->ForumSetting->set($this->data);

	       if ($this->ForumSetting->validates()) {
		    $this->ForumSetting->process($this->data);
		    $this->message(__d('forum', 'Settings have been updated!', true));
	       }
	  } else {
	       $this->data['Setting'] = $this->ForumToolbar->settings;
	  }

	  $this->set('title_for_layout', __d('forum', 'Settings', true) );
	  $this->set('menuTab', 'settings');
     }

     /**
      * Before filter.
      * 
      * @access public
      * @return void
      */
     public function beforeFilter() {
	  parent::beforeFilter();

	  //$this->Auth->allow('*');

	  if (isset($this->params['admin'])) {
	       $this->ForumToolbar->verifyAdmin();
	       $this->layout = 'admin';
	  }

	  $this->Security->validatePost = false;
     }

}
