<?php

/**
 * Cupcake - Forum Plugin AppController
 *
 * @author 		Miles Johnson - www.milesj.me
 * @copyright	Copyright 2006-2009, Miles Johnson, Inc.
 * @license 	http://www.opensource.org/licenses/mit-license.php - Licensed under The MIT License
 * @link		www.milesj.me/resources/script/forum-plugin
 */
App::import(array(
	'type' => 'File',
	'name' => 'Forum.ForumConfig',
	'file' => 'config' . DS . 'core.php'
));

class ForumAppController extends AppController {

	/**
	 * Remove parent models.
	 *
	 * @access public
	 * @var array
	 */
	public $uses = array();

	/**
	 * Components.
	 *
	 * @access public
	 * @var array
	 */
	public $components = array('RequestHandler', 'Security', 'Cookie', 'Auth',
		'Forum.ForumToolbar', 'Settings.Config');

	/**
	 * Helpers.
	 *
	 * @access public
	 * @var array
	 */
	public $helpers = array('Html', 'Session', 'Form', 'Forum.Time', 'Text', 'Javascript',
		'Forum.Cupcake', 'Forum.Decoda' => array());

	/**
	 * Run auto login logic.
	 *
	 * @access public
	 * @param array $user - The logged in User
	 * @return void
	 */
	public function _autoLogin($user) {
		ClassRegistry::init('Account.User')->login($user);

		$this->Session->delete('Forum');
		$this->ForumToolbar->initForum();
	}

	/**
	 * Refreshes the Auth to get new data.
	 *
	 * @access public
	 * @param string $field
	 * @param string $value
	 * @return void
	 */
	public function _refreshAuth($field = '', $value = '') {
		if (!empty($field) && !empty($value)) {
			$this->Session->write($this->Auth->sessionKey . '.' . $field, $value);
		} else {
			if (isset($this->User)) {
				$this->Auth->login($this->User->read(false, $this->Auth->user('id')));
			} else {
				$this->Auth->login(ClassRegistry::init('Account.User')->findById($this->Auth->user('id')));
			}
		}
	}

	/**
	 * Before filter.
	 * 
	 * @access public
	 * @return void
	 */
	public function beforeFilter() {
		parent::beforeFilter();

		Security::setHash('md5');
		$Config = ForumConfig::getInstance();

		// Load l10n/i18n support
		if ($this->Auth->user('locale')) {
			$locale = $this->Auth->user('locale');
		} else {
			$locale = (isset($Config->settings['default_locale']) ? $Config->settings['default_locale'] : 'eng');
		}

		Configure::write('Config.language', $locale);

		$lang = $this->_getLang($locale);
		setlocale(LC_ALL, $lang . '.UTF8', $lang . '.UTF-8', $lang, 'eng.UTF8', 'eng.UTF-8', 'eng', 'en_US');

		$this->Cookie->key = Configure::read('Security.salt');

		// Apply censored words
		if (!empty($Config->settings['censored_words'])) {
			$censored = explode(',', str_replace(', ', ',', $Config->settings['censored_words']));
			$this->helpers['Forum.Decoda'] = array('censored' => $censored);
		}

		$this->ForumToolbar->initForum();
	}

	function _getLang($string) {
		$l10n = new L10n();
		$lang = $l10n->map('pol');
		if (strlen($lang) === 2) {
			$lang = $lang . '_' . up($lang);
		}
		return $lang;
	}

	public function beforeRender() {
		parent::beforeRender();
		if (!empty($this->params['admin'])) {
			$this->Config->setLayout('forum', 'admin');
		}
	}

}

