<?php

class CategoryObserve extends ForumAppModel {
     var $name = 'CategoryObserve';
     var $useTable = 'categories_observe';
     
     function add($category_id){
	  if($this->check($category_id)) return false;
	  $data = array($this->name=> array(
	      'category_id'=> $category_id,
	      'user_id'=> $_SESSION['Auth']['User']['id']
	  ));

	  return $this->save($data);
     }

     function remove($category_id){
	  if(!$this->check($category_id)) return false;
	  $data = array($this->name=> array(
	      'category_id'=> $category_id,
	      'user_id'=> $_SESSION['Auth']['User']['id']
	  ));

	  $id = $this->field('id', $data[$this->name]);

	  return $this->delete($id);
     }

     function check($category_id){
	  if(empty($_SESSION['Auth']['User']['id'])) return false;

	  $data = array($this->name=> array(
	      'category_id'=> $category_id,
	      'user_id'=> $_SESSION['Auth']['User']['id']
	  ));

	  $this->updateAll( array('noticed'=>0), $data[$this->name]);
	  
	  return $this->field('id', $data[$this->name]);
     }
}