<?php // Search orderbY
$orderBy = array(
	'LastPost.created' => __d('forum', 'Last post time', true),
	'Topic.created' => __d('forum', 'Topic created time', true),
	'Topic.post_count' => __d('forum', 'Total posts', true),
	'Topic.view_count' => __d('forum', 'Total views', true)
); ?>
<div class="forumHeader">
	<h2><?php __d('forum','Search');?></h2>
</div>
<?php
echo $form->create('Topic', array('url' => array('controller' => 'search', 'action' => 'proxy')));
echo $form->hidden('power',array('value'=>1));
?>
<div id="search">
	<table cellpadding="0" cellspacing="0" border="0" style="width: 678px;">
    <tr id="search_first">
    	<td class="serch_label blue_l"><?php echo $form->label('keywords', __d('forum', 'Keywords', true) .':'); ?></td>
    	<td class="blue_l"><?php echo $form->input('keywords', array('div' => false, 'label' => false, 'style' => 'width: 445px;')); ?></td>
	</tr>
	<?php /*<tr>
		<td class="serch_label"><?php echo $form->input('power', array('div' => false, 'label' => false, 'type' => 'checkbox')); ?></td>
    	<td><?php echo $form->label('power', __d('forum', 'Power Search?', true)); ?></td>
	</tr>*/ ?>
	<tr>
		<td class="serch_label" style="padding-top:20px;"><?php echo $form->label('byUser', __d('forum', 'By User (Username)', true) .':'); ?></td>
    	<td style="padding-top:20px;"><?php echo $form->input('byUser', array('div' => false, 'label' => false, 'style' => 'width: 230px;')); ?></td>
   	</tr>
	<tr>
		<td class="serch_label"><?php echo $form->label('category', __d('forum', 'Within Forum Category', true) .':'); ?></td>
    	<td><?php echo $form->input('category', array('div' => false, 'label' => false, 'options' => $forums, 'escape' => false, 'empty' => true)); ?></td>
	</tr>
	<tr>
		<td class="serch_label" style="padding-bottom:20px;"><?php echo $form->label('orderBy', __d('forum', 'Order By', true) .':'); ?></td>
    	<td style="padding-bottom:20px;"><?php echo $form->input('orderBy', array('div' => false, 'label' => false, 'options' => $orderBy)); ?></td>
	</tr>
	<tr>
		<th colspan="2"><?php echo $form->end(__d('forum', 'Search Topics', true)); ?></th>
	</tr>
    </table>
</div>

<?php // Is searching
if ($searching === true) { ?>

<div class="forumWrap">
	<?php echo $this->element('pagination'); ?>
    
	<table cellspacing="0" class="table">
    <tr>
        <th colspan="2"><?php echo $paginator->sort(__d('forum', 'Topic', true), 'Topic.title'); ?></th>
        <th><?php echo $paginator->sort(__d('forum', 'Forum', true), 'Topic.forum_category_id'); ?></th>
        <?php /*echo $paginator->sort(__d('forum', 'Author', true), 'User.username'); */?>
        <th><?php echo $paginator->sort(__d('forum', 'Created', true), 'Topic.created'); ?></th>
        <th><?php echo $paginator->sort(__d('forum', 'Posts', true), 'Topic.post_count'); ?>
        <?php /*echo $paginator->sort(__d('forum', 'Views', true), 'Topic.view_count'); */?></th>
        <th><?php echo $paginator->sort(__d('forum', 'Activity', true), 'LastPost.created'); ?></th>
    </tr>
    
    <?php if (empty($topics)) { ?>
    <tr>
    	<td colspan="8" class="empty"><?php __d('forum', 'No results were found, please refine your search criteria.'); ?></td>
   	</tr>
    <?php } else {
		$counter = 0;
		foreach ($topics as $topic) {
        	$pages = $cupcake->topicPages($topic['Topic']); ?>
   
   	<tr<?php if ($counter % 2) echo ' /*class="altRow"*/'; ?>>
    	<td class="ac" style="width: 35px"><?php echo $cupcake->topicIcon($topic); ?></td>
        <td>
        	<strong>
        	<?php if (!empty($topic['Poll']['id'])) { 
				echo $html->image('/forum/img/poll.png', array('alt' => 'Poll', 'class' => 'img'));
			} ?>
            
        	<?php echo $cupcake->topicType($topic['Topic']['type']); ?> 
        	<?php echo $html->link($topic['Topic']['title'], array('controller' => 'topics', 'action' => 'view', 'id'=> $topic['Topic']['id'], 'slug'=> slug($topic['Topic']['title'] ))); ?>
			</strong>
            
            <?php if (count($pages) > 1) { ?>
            <br /><span class="gray"><?php __d('forum', 'Pages'); ?>: [ <?php echo implode(', ', $pages); ?> ]</span>
            <?php } ?>
        </td>
        <td class="ac"><?php echo $html->link($topic['ForumCategory']['title'], array('controller' => 'categories', 'action' => 'view','id'=> $topic['ForumCategory']['id'], 'slug'=> slug($topic['ForumCategory']['title'] ))); ?></td>
        <td class="ac" style="text-align:left; white-space:nowrap;"><?php echo $time->niceShort($topic['Topic']['created'], $cupcake->timezone()); ?><br />
		<span class="gray"><?php __d('forum', 'by'); ?></span> <?php echo $html->link($topic['User']['username'], array('controller' => 'users', 'action' => 'profile', $topic['User']['id'])); ?></td>
        <td class="ac">
        	<?php __d('forum', 'Posts'); ?>:&nbsp;<?php echo number_format($topic['Topic']['post_count']); ?><br />
        	<?php __d('forum', 'Views'); ?>:&nbsp;<?php echo number_format($topic['Topic']['view_count']); ?>
		</td>
        <td style="white-space:nowrap;" >
            <?php // Last activity
            if (!empty($topic['LastPost'])) {
                $lastTime = (!empty($topic['LastPost']['created'])) ? $topic['LastPost']['created'] : $topic['Topic']['modified']; ?>
                
                <em><?php echo $time->relativeTime($lastTime, array('userOffset' => $cupcake->timezone())); ?></em><br />
                <span class="gray"><?php __d('forum', 'by'); ?> <?php echo $html->link($topic['LastUser']['username'], array('controller' => 'users', 'action' => 'profile', $topic['Topic']['lastUser_id'])); ?></span>
                <?php echo $html->image('/forum/img/goto.png', array('alt' => '', 'url' => array('controller' => 'topics', 'action' => 'view','id'=> $topic['Topic']['id'], 'slug'=> slug( $topic['Topic']['title']) , 'page' => $topic['Topic']['page_count'], '#' => 'post_'. $topic['Topic']['lastPost_id']))); ?>
            <?php } else {
				__d('forum', 'No latest activity to display');
			} ?>
        </td>
	</tr>
        
        <?php ++$counter; 
		} 
	} ?>
    </table>
    
	<?php echo $this->element('pagination'); ?>
</div>
<?php } ?>
