// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2008 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
// BBCode tags example
// http://en.wikipedia.org/wiki/Bbcode
// ----------------------------------------------------------------------------
// Feel free to add more tags
// ----------------------------------------------------------------------------
mySettings = {
	nameSpace: 'bbcode',
	previewParserPath: '', // path to your BBCode parser
	markupSet: [
		{name:'Pogrubienie', key:'B', openWith:'[b]', closeWith:'[/b]'},
		{name:'Pochylenie', key:'I', openWith:'[i]', closeWith:'[/i]'},
		{name:'Podkre\u015blenie', key:'U', openWith:'[u]', closeWith:'[/u]'},
		{separator:'---------------' },
		{name:'Obraz', key:'I', replaceWith:'[img][![Url]!][/img]'},
		{name:'Odno\u015bnik', key:'L', openWith:'[url=[![Url]!]]', closeWith:'[/url]', placeHolder:'Nazwa odnośnika...'},
		{name:'Email', key:'E', openWith:'[email=[![Email]!]]', closeWith:'[/email]', placeHolder:'Adres email...'},
		{separator:'---------------' },
		{name:'Kolory', openWith:'[color=[![Color]!]]', closeWith:'[/color]', dropMenu: [
			{name:'Yellow', openWith:'[color=yellow]', closeWith:'[/color]', className:"col1-1" },
			{name:'Orange', openWith:'[color=orange]', closeWith:'[/color]', className:"col1-2" },
			{name:'Red', openWith:'[color=red]', closeWith:'[/color]', className:"col1-3" },
			{name:'Blue', openWith:'[color=blue]', closeWith:'[/color]', className:"col2-1" },
			{name:'Purple', openWith:'[color=purple]', closeWith:'[/color]', className:"col2-2" },
			{name:'Green', openWith:'[color=green]', closeWith:'[/color]', className:"col2-3" },
			{name:'White', openWith:'[color=white]', closeWith:'[/color]', className:"col3-1" },
			{name:'Gray', openWith:'[color=gray]', closeWith:'[/color]', className:"col3-2" },
			{name:'Black', openWith:'[color=black]', closeWith:'[/color]', className:"col3-3" }
		]},
		{name:'Rozmiar', openWith:'[size=[![Text size]!]]', closeWith:'[/size]', dropMenu :[
			{name:'Du\u017cy', openWith:'[size=29]', closeWith:'[/size]' },
			{name:'\u015aredni', openWith:'[size=20]', closeWith:'[/size]' },
			{name:'Ma\u0142y', openWith:'[size=10]', closeWith:'[/size]' }
		]},
		{name:'Wyrównanie', openWith:'[align=[![Direction]!]]', closeWith:'[/align]', dropMenu:[
			{name:'Lewo', className:'left', openWith:'[align=left]', closeWith:'[/align]' },
			{name:'\u015arodek', className:'center', openWith:'[align=center]', closeWith:'[/align]' },
			{name:'Prawo', className:'right', openWith:'[align=right]', closeWith:'[/align]' }
		]},
		{separator:'---------------' },
		{name:'Lista numerowana', openWith:'[list]\n', closeWith:'\n[/list]'},
		//{name:'Numeric list', openWith:'[list=[![Starting number]!]]\n', closeWith:'\n[/list]'},
		{name:'Element listy', openWith:'[li]', closeWith:'[/li]'},
		{separator:'---------------' },
		{name:'Cytat', key:'Q', openWith:'[quote]', closeWith:'[/quote]'},
		{name:'Kod', openWith:'[code]', closeWith:'[/code]'},
		{separator:'---------------' },
		{name:'Wyczy\u015bć', className:"clean", replaceWith: function(markitup) { return markitup.selection.replace(/\[(.*?)\]/g, "") } },
		//{name:'Preview', className:"preview", call:'preview' }
	]
}