<?php

class AnswersController extends LearningAppController {
	var $uses = array('Learning.Answer', 'Learning.AnswerGrade', 'Learning.Unit', 'Learning.Team', 'Account.Profile');
	var $helpers = array('Text', 'Time', 'TinyMce.TinyMce');
	var $components = array('Filter');

	var $modelParams = array(
		'name' => 'Answer',
		'contain' => array(
			'Unit'=>array('fields'=>array('Unit.*') ),
			'AnswerPicture',
			'User'=>array('fields'=>array('User.*')),
			'AnswerGrade'=>array('User'=>array('fields'=>'User.*'),'fields'=>array('AnswerGrade.*'))
		),
		'foreign' => 'AnswerPicture'
	);

	function __dataForEdit($id){
		$pictures = $this->Answer->AnswerPicture->find('all', array('conditions'=> array('answer_id'=> $id)));
		$this->set('pictures', $pictures);
	}

	function admin_view($id){
		$this->__dataForEdit($id);
		$answer = $this->Answer->get($id,array(),$this->modelParams['contain']);
		$this->set('answer', $answer);
		$this->set('title_for_layout', 'Szczegóły odpowiedzi');
	}

	function admin_index() {
		$this->paginate['Answer']['limit'] = 30;
		$this->set('title_for_layout', 'Odpowiedzi');
		$this->paginate['Answer']['order'] = array('Answer.created'=> 'DESC');
		$this->paginate['Answer']['contain'] = $this->modelParams['contain'];
		$this->NewFilter->filter($this->Answer->filterData, 'Answer');
		$records = $this->paginate( $this->modelParams['name'] );
		$this->set('records', $records);
	}

	function admin_team_index($unit_id = null) {
		if(!$unit_id) $this->alert('Brak numeru ID zajęcia', $this->referer() );

		$unit = $this->Unit->get($unit_id);
		$this->set('unit', $unit);

		$this->paginate[ $this->modelParams['name'] ]['limit'] = 30;
		$this->paginate[ $this->modelParams['name'] ]['order'] = array('Answer.created'=> 'DESC');
		$this->Filter->filter(
			array(
				'grade' => array('accepted = #replace#'),
			), $this->modelParams['name']
		);
		$this->paginate[ $this->modelParams['name'] ]['conditions']['Answer.unit_id'] = $unit_id;
		$this->paginate[ $this->modelParams['name'] ]['contain'] = array('Unit', 'User'=> array('AnswerGrade'=>array('conditions'=> array('AnswerGrade.unit_id'=> $unit_id)),'Profile'));

		$records = $this->paginate( $this->modelParams['name'] );
		$records = Set::combine($records, 
			'{n}.Answer.id',
			'{n}',
			'{n}.User.Profile.team_id'
		);
		$this->set('records', $records);
		$this->set('teams', $this->Team->getList( $this->getClassesId() ));

		$this->set('title_for_layout', 'Odpowiedzi zespołów');
	}

	function admin_team_grade($unit_id = null, $team_id = null) {

		$students = $this->Profile->find('all', array('conditions'=> array('team_id'=> $team_id), 'contain'=> array('User')));
		$students_id = Set::combine($students, '{n}.User.id', '{n}.User.id');
		$answers = $this->Answer->find('all', array(
			'conditions'=> array('Answer.user_id'=> $students_id),
			'contain'=> $this->modelParams['contain']
		) );
		$answers = Set::combine($answers, '{n}.Answer.user_id', '{n}');
		$unit = $this->Unit->get($unit_id);
		if (!empty($this->data)) {
			if ($this->AnswerGrade->saveForTeam($this->data,$unit_id,$team_id)) {
				$this->message('Wystawiono oceny dla zespołu!', array('action'=> 'team_index', $unit_id, $team_id ));
			} else {
				$this->alert('Wystąpił błąd w formularzu!');
			}
		} else {
			$grades = $this->AnswerGrade->find('all', array('conditions'=> array('unit_id'=> $unit_id, 'author_id'=> $students_id) ));;
			$this->data['AnswerGrade'] = Set::combine($grades,'{n}.AnswerGrade.author_id', '{n}.AnswerGrade');
		}
		$this->set('teams', $this->Team->getList( $this->getClassesId() ));
		$this->set(compact('students','answers','unit','unit_id','team_id'));
		$this->set('title_for_layout', 'Ocena zespołu');
	}

	function admin_grade($id = null) {
		
		$this->set('title_for_layout', 'Ocena do odpowiedzi');
		$answer = $this->Answer->get($id, array(), $this->modelParams['contain']);
		$this->set('answer', $answer);
		
		if (!empty($this->data)) {
			$this->data['AnswerGrade']['user_id'] = $this->Auth->user('id');
			$this->data['AnswerGrade']['author_id'] = $answer['Answer']['user_id'];
			if($id) {
				$this->data['AnswerGrade']['unit_id'] = $answer['Answer']['unit_id'];
			}
			$this->data['AnswerGrade']['answer_id'] = $id;
			if ($this->Answer->AnswerGrade->save($this->data)) {
				$this->message('Wystawiono ocenę!', 'index');
			} else {
				$this->alert('Wystąpił błąd w formularzu!');
			}
		} else {
			$this->data = $this->AnswerGrade->get( array('author_id'=> $answer['Answer']['user_id'], 'unit_id'=>$answer['Answer']['unit_id']));
		}

		$this->__dataForEdit($id);
	}

	function admin_edit($id = null) {
		if(!$id) $this->alert('Brak numeru ID', $this->referer());
		$answer = $this->Answer->get($id);
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else {
				$this->alert('Rekord nie zostal zapisany!');
			}
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		}

		$this->set(compact( 'answer' ));
		$this->__dataForEdit($id);
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else{
			$this->alert('Rekord nie został usunięty!');
		}
		$this->redirect($this->referer());
	}

	function admin_delete_picture($id){

		if($this->Answer->AnswerPicture->delete($id)){
			$this->message('Obraz został skasowany!');
		} else $this->alert('Obraz nie został skasowany!');

		$this->redirect($this->referer());
	}

	/** TEACHER PART **/
	function teacher_view($id){
		$this->__dataForEdit($id);
		$answer = $this->Answer->get($id,array(),$this->modelParams['contain']);
		$this->set('answer', $answer);
		$this->set('title_for_layout', 'Szczegóły odpowiedzi');
	}

	function teacher_index() {
		$this->paginate[ $this->modelParams['name'] ]['limit'] = 30;
		$this->set('title_for_layout', 'Odpowiedzi uczniów');
		$this->paginate[ $this->modelParams['name'] ]['order'] = array('Answer.created'=> 'DESC');
		if(isset($this->params['named']['grade'])) {
			$this->paginate[ $this->modelParams['name'] ]['conditions']['accepted'] = $this->params['named']['grade']?1:0;
		}
		$this->paginate[ $this->modelParams['name'] ]['conditions']['Answer.user_id'][] = $this->Profile->find('list', array('fields'=> array('user_id','user_id'), 'conditions'=>array('class_id'=> $this->getClassesId() ) ) );

		$this->paginate[ $this->modelParams['name'] ]['contain'] = $this->modelParams['contain'];
		
		$this->NewFilter->filter($this->Answer->filterData, 'Answer');
		$records = $this->paginate( $this->modelParams['name'] );
		$this->set('records', $records);
	}

	function teacher_team_index($unit_id = null) {
		if(!$unit_id) $this->alert('Brak numeru ID zajęcia', $this->referer() );

		$unit = $this->Unit->get($unit_id);
		$this->set('unit', $unit);

		$this->paginate[ $this->modelParams['name'] ]['limit'] = 30;
		$this->paginate[ $this->modelParams['name'] ]['order'] = array('Answer.created'=> 'DESC');
		$this->Filter->filter(
			array('grade' => array('accepted = #replace#')), $this->modelParams['name']
		);
		$this->paginate[ $this->modelParams['name'] ]['conditions']['Answer.unit_id'] = $unit_id;
		$this->paginate[ $this->modelParams['name'] ]['conditions']['Answer.user_id'] = $this->Profile->find('list', array('fields'=> array('user_id','user_id'), 'conditions'=>array('class_id'=> $this->getClassesId() ) ) );
		$this->paginate[ $this->modelParams['name'] ]['contain'] = array(
			'Unit',
			'User'=> array(
				'AnswerGrade'=>array('conditions'=> array('AnswerGrade.unit_id'=> $unit_id)),
				'Profile'
			));

		$records = $this->paginate( $this->modelParams['name'] );
		$records = Set::combine($records,
			'{n}.Answer.id',
			'{n}',
			'{n}.User.Profile.team_id'
		);
		$this->set('records', $records);
		$this->set('teams', $this->Team->getList( $this->getClassesId() ));
		$this->set('title_for_layout', 'Odpowiedzi zespołów');
	}

	function teacher_team_grade($unit_id = null, $team_id = null) {

		$students = $this->Profile->find('all', array('conditions'=> array('team_id'=> $team_id), 'contain'=> array('User')));
		$students_id = Set::combine($students, '{n}.User.id', '{n}.User.id');
		$answers = $this->Answer->find('all', array(
			'conditions'=> array('Answer.user_id'=> $students_id),
			'contain'=> $this->modelParams['contain']
		) );
		$answers = Set::combine($answers, '{n}.Answer.user_id', '{n}');
		$unit = $this->Unit->get($unit_id);
		if (!empty($this->data)) {
			if ($this->AnswerGrade->saveForTeam($this->data,$unit_id,$team_id)) {
				$this->message('Wystawiono oceny dla zespołu!', array('action'=> 'team_index', $unit_id, $team_id ));
			} else {
				$this->alert('Wystąpił błąd w formularzu!');
			}
		} else {
			$grades = $this->AnswerGrade->find('all', array('conditions'=> array('unit_id'=> $unit_id, 'author_id'=> $students_id) ));;
			$this->data['AnswerGrade'] = Set::combine($grades,'{n}.AnswerGrade.author_id', '{n}.AnswerGrade');
		}
		$this->set('teams', $this->Team->getList( $this->getClassesId() ));
		$this->set(compact('students','answers','unit','unit_id','team_id'));
		$this->set('title_for_layout', 'Ocena zespołu');
	}

	function teacher_grade($id = null) {

		$this->set('title_for_layout', 'Ocena do odpowiedzi');
		$answer = $this->Answer->get($id, array(), $this->modelParams['contain']);
		$this->set('answer', $answer);

		if (!empty($this->data)) {
			$this->data['AnswerGrade']['user_id'] = $this->Auth->user('id');
			$this->data['AnswerGrade']['author_id'] = $answer['Answer']['user_id'];
			if($id) {
				$this->data['AnswerGrade']['unit_id'] = $answer['Answer']['unit_id'];
			}
			$this->data['AnswerGrade']['answer_id'] = $id;
			if ($this->Answer->AnswerGrade->save($this->data)) {
				$this->message('Wystawiono ocenę!', 'index');
			} else {
				$this->alert('Wystąpił błąd w formularzu!');
			}
		} else {
			$this->data = $this->AnswerGrade->get( array('author_id'=> $answer['Answer']['user_id'], 'unit_id'=>$answer['Answer']['unit_id']));
		}

		$this->__dataForEdit($id);
	}

	function teacher_edit($id = null) {
		if(!$id) $this->alert('Brak numeru ID', $this->referer());
		$answer = $this->Answer->get($id);
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else {
				$this->alert('Rekord nie zostal zapisany!');
			}
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		}


		$this->set(compact( 'answer' ));
		$this->__dataForEdit($id);
	}

	function teacher_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else{
			$this->alert('Rekord nie został usunięty!');
		}
		$this->redirect($this->referer());
	}

	function teacher_delete_picture($id){

		if($this->Answer->AnswerPicture->delete($id)){
			$this->message('Obraz został skasowany!');
		} else $this->alert('Obraz nie został skasowany!');

		$this->redirect($this->referer());
	}

	/** USER PART **/
	function user_edit() {
		$id = $this->Config->getParam('id', 'Niepoprawny parametr (#ID)');
		$record = $this->Unit->get($id);
		$this->checkUnit($record);

		$conditions = array('user_id'=>$this->Auth->user('id'), 'unit_id'=>$id  );
		$answer = $this->Answer->get($conditions);
		if(!empty($this->data)) {

			if($answer) $this->data['Answer']['id'] = $answer['Answer']['id'];
			$this->data['Answer']['unit_id'] = $id;
			$this->data['Answer']['user_id'] = $this->Auth->user('id');
			if($this->Answer->saveAll($this->data)) {
				$this->message('Twoja odpowiedź została zapisana!', array('controller'=> 'units', 'action'=> 'view', 'id'=> $id, 'slug'=> slug($record['Unit']['name']) ));
			}else $this->alert('Błąd w formularzu!');
		} else {
			$this->data = $this->Answer->get($conditions);
		}

		$pictures = array();
		if($answer) $pictures = $this->Answer->AnswerPicture->find('all', array('conditions'=> array('answer_id'=> $answer['Answer']['id'])));
		
		$this->set( compact( 'record', 'id', 'pictures', 'answer' ));
		$this->set('title_for_layout', $record['Unit']['name'] . ' - dodaj odpowiedź');

	}

	function user_delete_picture($id){
		$picture = $this->Answer->AnswerPicture->get($id, array(), array('Answer'=>array('id','unit_id')));
		$record = $this->Unit->get($picture['Answer']['unit_id']);
		$this->checkUnit($record);

		if($this->Answer->AnswerPicture->delete($id)){
			$this->message('Obraz został skasowany!');
		} else $this->alert('Obraz nie został skasowany!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->Config->selectMenu('units');
		$this->set('modelParams', $this->modelParams);
	}
}