<?php

class ClassesController extends LearningAppController {

	var $uses = array('Learning.Classes', 'Learning.School');

	var $modelParams = array(
		'name' => 'Classes',
		'contain' => array('School')
	);
	
	function _dataForEdit() {
		$this->set('schools', $this->School->find('list'));
	}

	function admin_index() {
		$this->NewFilter->filter($this->Classes->filterData, 'Classes');
		$this->set('title_for_layout', 'Lista klas');
		$this->paginate['Classes']['contain'] = $this->modelParams['contain'];
		$this->paginate['Classes']['order']['Classes.created'] = 'DESC';
		$records = $this->paginate($this->modelParams['name']);
		
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}

		$this->_dataForEdit();
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
	}

}