<?php

class GradesController extends LearningAppController {
	var $uses = array('Account.User','Learning.AnswerGrade', 'Learning.Grade', 'Learning.Classes', 'LearningAccount.Group', 'Learning.Team', 'Account.Profile');
	var $helpers = array('Js','Time');
	var $modelParams = array(
		'name' => 'Grade',
		'contain' => array('User','Student'=> array('Profile'=> array('Team','Group')))
	);
	var $components = array('Filter','NewFilter');
	/** USER PART **/

	function user_index($user_id = null){
		
		if(!$user_id || (!$this->Auth->user('admin') && !$this->Auth->user('teacher'))) {
			$user_id = $this->Auth->user('id');
		}
		
		$gradeSum			=	$this->Grade->findSum($user_id);
		$answerGradeSum	=	$this->AnswerGrade->findSum($user_id);

		$sum = $gradeSum[1] + $gradeSum[2] +  $gradeSum[3] + $answerGradeSum;
		
		$bestInSchool = $this->Grade->bestInSchool( $user_id ); 
		$schoolPosition = $this->Grade->schoolPosition( $user_id );
		
		$bestInClass = $this->Grade->bestInClass( $user_id ); 
		
		$classPosition = $this->Grade->classPosition( $user_id );
		
		$bestIn = $this->Grade->bestIn( $user_id );
		$projectPosition = $this->Grade->projectPosition( $user_id );
		
		$bestInGroup = $this->Grade->bestInGroup( $user_id ); 	
		$groupPosition = $this->Grade->groupPosition( $user_id );
		
		
		
		$this->set(compact('projectPosition','groupPosition','bestIn','bestInGroup','user_id','answerGradeSum', 'sum', 'gradeSum','bestInSchool', 'bestInClass', 'schoolPosition', 'classPosition'));
		
		if($user_id) $this->set('title_for_layout', $this->User->field('username', array('id'=> $user_id)).' - oceny ucznia');
		else $this->set('title_for_layout', 'Moje oceny');
	}

	function user_details($type = null,$user_id){
		if($type === null) $this->alert('Błędne dane wejściowe!', $this->referer() );
		
		if(!$user_id || (!$this->Auth->user('admin') && !$this->Auth->user('teacher'))) {
			$user_id = $this->Auth->user('id');
		}

		switch ($type) {
			case 1:
				$this->set('title_for_layout', 'Historia ocen');
				if($user_id) $this->set('title_for_layout', $this->User->field('username',array('id'=>$user_id)).' - Historia ocen');
				
				$records = $this->Grade->find('all', array('conditions'=> array('student_id'=> $user_id), 'contain'=> array('User')));
				$element = 'grades';
				$gradeSum	= $this->Grade->findSum($user_id);
				$this->set('sum', array_sum( $gradeSum));
				break;
			case 4:
				$this->set('title_for_layout', 'Historia ocen');
				if($user_id) $this->set('title_for_layout', $this->User->field('username',array('id'=>$user_id)).' - Punkty za zajęcia');
				$records = $this->AnswerGrade->find('all', array('conditions'=> array('author_id'=> $user_id), 'contain'=> array('Unit','User') ));
				$element = 'answers_grades';
				$this->set('sum', $this->AnswerGrade->findSum($user_id));
				break;
		}

		$this->set('element', $element);
		$this->set('records', $records);
	}
	
	function _dataForEdit() {
		$this->set('types', $this->Grade->types);

		$classes_ids = $this->getClassesId();
		$this->set('classes', $this->Classes->getList($classes_ids));
		$data = array();
		$groups = $this->Group->find('all', array('conditions' => array('Group.class_id' => $classes_ids)));
		$data['groups'] = Set::combine($groups, '{n}.Group.id', '{n}.Group.name', '{n}.Group.class_id');
		$teams = $this->Team->find('all', array('conditions' => array('Group.class_id' => $classes_ids), 'contain' => 'Group'));
		$data['teams'] = Set::combine($teams, '{n}.Team.id', '{n}.Team.name', '{n}.Team.group_id');
		$users = $this->Profile->find('all', array('conditions' => array('Profile.class_id' => $classes_ids), 'contain' => 'User'));
		$data['users'] = Set::combine($users, '{n}.User.id', '{n}.User.username', '{n}.Profile.team_id');
		$this->set('data', $data);
	}

	function admin_index() {
		$this->set('title_for_layout', 'Lista ocen');
		
		$this->NewFilter->filter(
			$this->Grade->filterData, $this->modelParams['name']
		);
		
//		array(
//				'username' => array('Student.username LIKE "%#replace#%"'),
//				'class' => array('Student.id IN ( SELECT user_id FROM profiles WHERE class_id IN (SELECT id FROM learning_classes WHERE name LIKE "%#replace#%"))'),
//				'group' => array('Student.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_groups WHERE name LIKE "%#replace#%"))'),
//				'team' => array('Student.id IN ( SELECT user_id FROM profiles WHERE team_id IN (SELECT id FROM learning_teams WHERE name LIKE "%#replace#%"))')
//			)
		
		$this->paginate['Grade']['contain'] = $this->modelParams['contain'];
		$this->paginate['Grade']['order'] = 'Grade.published DESC';
		$records = $this->paginate($this->modelParams['name']);

		$this->set('records', $records);
		$this->set('types', $this->Grade->types);
	}

	function admin_add() {
		if (!empty($this->data)) {
			$this->{ $this->modelParams['name'] }->set($this->data);
			if ($this->{ $this->modelParams['name'] }->validates($this->data)) {
				$this->message('Wprowadź oceny dla uczniów',array('action'=>'publish') + $this->data['Grade']);
			} else {
				$this->alert('Rekord nie zostal zapisany!');
			}
		} elseif (!empty($this->params['named'])) {
			$this->data['Grade'] = $this->params['named'];
		}

		$this->set('title_for_layout', 'Dodaj ocenę');
		$this->_dataForEdit();
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			$this->{ $this->modelParams['name'] }->set($this->data);
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Ocena została zapisana!', 'index');
			} else {
				$this->alert('Ocena nie została zapisana!');
			}
		} elseif ($id) {
			$this->data = $this->Grade->get($id);
		}

		$this->set('profileName', $this->Profile->User->field('username', array('id'=> $this->Grade->field( 'student_id', array('id'=>$id) )) ));
		$this->set('title_for_layout', 'Edytuj ocenę');
		$this->_dataForEdit();
	}

	function admin_publish(){
		$params = $this->params['named'];
		if(isset($params['user_id'])) {
			$conditions = array('Profile.user_id' => $params['user_id']);
			$title_for_layout = sprintf('Ocena dla użytkowika %s', $this->Profile->User->field('username', array('id'=> $params['user_id'])) );
		} elseif(isset($params['team_id'])) {
			$conditions = array('Profile.team_id' => $params['team_id']);
			$team = $this->Team->find('first', array('conditions'=>array( 'Team.id'=> $params['team_id']),'contain'=>  array('Group'=>array('Classes'=>'School'))  ));
			$title_for_layout = sprintf('Ocena dla zespołu %s (%s / %s / %s)', $team['Team']['name'], $team['Group']['Classes']['School']['name'], $team['Group']['Classes']['name'], $team['Group']['name']);
		} elseif(isset($params['group_id'])) {
			$conditions = array('Profile.group_id' => $params['group_id']);
			$group = $this->Group->find('first', array('conditions'=>array( 'Group.id'=> $params['group_id']),'contain'=>  array('Classes'=>'School')  ));
			$title_for_layout = sprintf('Ocena dla grupy %s (%s / %s)',  $group['Group']['name'], $group['Classes']['School']['name'], $group['Classes']['name']);

		} elseif(isset($params['class_id'])) {
			$conditions = array('Profile.class_id' => $params['class_id']);
			$class = $this->Classes->find('first', array('conditions'=>array( 'Classes.id'=> $params['class_id']),'contain'=>  array('School')  ));
			$title_for_layout = sprintf('Ocena dla klasy %s (%s)',  $class['Classes']['name'], $class['School']['name']);

		} else {
			$this->alert('Błędne parametry #grades,edit!', $this->referer() );
		}

		if(!empty($this->data)) {
			if( $this->Grade->saveAll($this->data['Grade'], array('validate'=> 'only')) ){
				if( $this->Grade->customSaveAll($this->data['Grade'])){
					$this->message('Wystawiono oceny!', 'index');
				} else $this->alert('Wystąpił błąd podczas wprowadzania ocen!');
			} else $this->alert('Błąd w formularzu');
		}
		else {
			$this->data['Grade'][0]['published'] = date('Y-m-d');
		}

		$this->set('title_for_layout', $title_for_layout);
		$profiles = $this->Profile->find('all', array('conditions'=> $conditions, 'contain'=> array('User','Group','Team','Classes'=> 'School')) );
		if(!$profiles) $this->alert('Brak uczniów!', $this->referer());
		$this->set('profiles', $profiles);
		$this->_dataForEdit();
		$this->set('params', $this->params['named']);
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	/** TEACHER PART **/
	
	function teacher_logged_index(){
		$this->set('title_for_layout', 'Twoje oceny');
		$this->NewFilter->filter($this->Grade->filterDataTeacher, 'Grade');
		$records = $this->__gradesList(array('Grade.user_id'=> $this->Auth->user('id')));
		$this->set('records', $records);
		$this->set('types', $this->Grade->types);		
	}

	function teacher_index() {
		$this->set('title_for_layout', 'Lista ocen');
		$this->NewFilter->filter($this->Grade->filterData, 'Grade');
		$records = $this->__gradesList();
		$this->set('records', $records);
		$this->set('types', $this->Grade->types);
	}
	
	private function __gradesList($conditions = array()){
		
		
		 
		$this->paginate['Grade']['contain'] = $this->modelParams['contain'];
		$this->paginate['Grade']['conditions'][] = array('Grade.student_id'=> $this->Profile->find('list', array('class_id'=> $this->getClassesId(),'fields'=> array('user_id','user_id')  ) ) );
		$this->paginate['Grade']['order'] = 'Grade.published DESC';
		$records = $this->paginate('Grade');		
		
		return $records;
	}

	function teacher_add() {
		if (!empty($this->data)) {
			$this->{ $this->modelParams['name'] }->set($this->data);
			if ($this->{ $this->modelParams['name'] }->validates($this->data)) {
				$this->message('Wprowadź oceny dla uczniów',array('action'=>'publish') + $this->data['Grade']);
			} else {
				$this->alert('Rekord nie został zapisany!');
			}
		} elseif (!empty($this->params['named'])) {
			$this->data['Grade'] = $this->params['named'];
		}

		$this->set('title_for_layout', 'Dodaj ocenę');
		$this->_dataForEdit();
	}

	function teacher_edit($id = null) {
		if (!empty($this->data)) {
			$this->{ $this->modelParams['name'] }->set($this->data);
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Ocena została zapisana!', 'index');
			} else {
				$this->alert('Ocena nie została zapisana!');
			}
		} elseif ($id) {
			$this->data = $this->Grade->get($id);
		}

		$this->set('profileName', $this->Profile->User->field('username', array('id'=> $this->Grade->field( 'student_id', array('id'=>$id) )) ));
		$this->set('title_for_layout', 'Edytuj ocenę');
		$this->_dataForEdit();
	}

	function teacher_publish(){
		$params = $this->params['named'];
		if(isset($params['user_id'])) {
			$conditions = array('Profile.user_id' => $params['user_id']);
			$title_for_layout = sprintf('Ocena dla użytkowika %s', $this->Profile->User->field('username', array('id'=> $params['user_id'])) );
		} elseif(isset($params['team_id'])) {
			$conditions = array('Profile.team_id' => $params['team_id']);
			$team = $this->Team->find('first', array('conditions'=>array( 'Team.id'=> $params['team_id']),'contain'=>  array('Group'=>array('Classes'=>'School'))  ));
			$title_for_layout = sprintf('Ocena dla zespołu %s (%s / %s / %s)', $team['Team']['name'], $team['Group']['Classes']['School']['name'], $team['Group']['Classes']['name'], $team['Group']['name']);
		} elseif(isset($params['group_id'])) {
			$conditions = array('Profile.group_id' => $params['group_id']);
			$group = $this->Group->find('first', array('conditions'=>array( 'Group.id'=> $params['group_id']),'contain'=>  array('Classes'=>'School')  ));
			$title_for_layout = sprintf('Ocena dla grupy %s (%s / %s)',  $group['Group']['name'], $group['Classes']['School']['name'], $group['Classes']['name']);

		} elseif(isset($params['class_id'])) {
			$conditions = array('Profile.class_id' => $params['class_id']);
			$class = $this->Classes->find('first', array('conditions'=>array( 'Classes.id'=> $params['class_id']),'contain'=>  array('School')  ));
			$title_for_layout = sprintf('Ocena dla klasy %s (%s)',  $class['Classes']['name'], $class['School']['name']);

		} else {
			$this->alert('Błędne parametry #grades,edit!', $this->referer() );
		}

		if(!empty($this->data)) {
			if( $this->Grade->saveAll($this->data['Grade'], array('validate'=> 'only')) ){
				if( $this->Grade->customSaveAll($this->data['Grade'])){
					$this->message('Wystawiono oceny!', 'index');
				} else $this->alert('Wystąpił błąd podczas wprowadzania ocen!');
			} else $this->alert('Błąd w formularzu');
		}
		else {
			$this->data['Grade'][0]['published'] = date('Y-m-d');
		}


		$this->set('title_for_layout', $title_for_layout);
		$profiles = $this->Profile->find('all', array('conditions'=> $conditions, 'contain'=> array('User','Group','Team','Classes'=> 'School')) );
		if(!$profiles) $this->alert('Brak uczniów!', $this->referer());
		$this->set('profiles', $profiles);
		$this->_dataForEdit();
		$this->set('params', $this->params['named']);
	}

	function teacher_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}


	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
	}

}