<?php

class SchoolsController extends LearningAppController {

	var $modelParams = array(
		'name' => 'School',
		'contain' => array('User')
	);
	var $uses = array('Learning.School');

	function admin_index() {
		$this->set('title_for_layout', 'Lista szkół');
		$this->NewFilter->filter($this->School->filterData, 'School');
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}

		$this->set('avatar', $this->{ $this->modelParams['name'] }->field('avatar', array('id' => $id)));
	}
	
	function admin_raports($id){
		
		$school = $this->School->get($id);
		$title_for_layout = $school['School']['name'] . ' - Lista raportów do pobrania dla szkoły';
		
		
		
		$this->set(compact('title_for_layout','id','school'));
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
	}

}