<?php

class TeachersController extends LearningAppController {

	var $modelParams = array(
		'name' => 'Teacher',
		'contain' => array('Classes', 'User' => array('fields' => array('id', 'email', 'username')))
	);
	var $uses = array(
		'Learning.Teacher', 'Learning.Classes', 'LearningAccount.Group', 'Learning.TeacherClass', 'Learning.Grade', 'Account.Profile'
	);

	function _dataForEdit() {
		$this->set('classes', $this->Classes->getList($this->getClassesId()));
	}

	function admin_index() {
		$this->set('title_for_layout', 'Lista kont nauczycieli');
		
		$this->NewFilter->filter($this->Teacher->filterData, 'Teacher');
		$this->paginate['Teacher']['contain'] = $this->modelParams['contain'];
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if (!$id) {
				$password = $this->{ $this->modelParams['name'] }->User->generate();
				$this->data['User']['password'] = $this->Auth->password($password);
				$this->data['User']['teacher'] = 1;
				$this->data['User']['active'] = 1;
			}

			if ($this->{ $this->modelParams['name'] }->saveAll($this->data, array('validate' => 'first'))) {
				if (!$id) {
					$emailSent = $this->Config->emailSend(array(
							'to' => $this->data['User']['email'],
							'subject' => 'Konto nauczyciela zostało założone',
							'template' => 'teacher_add',
							'data' => array('password' => $password, 'email' => $this->data['User']['email'])
						));
				}

				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');

			$this->data = $this->{ $this->modelParams['name'] }->get($id, array(), $this->modelParams['contain']);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}

		$this->_dataForEdit();
	}

	function admin_delete($id = null) {
		$user_id = $this->{ $this->modelParams['name'] }->field('user_id', array('id' => $id));

		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->{ $this->modelParams['name'] }->User->delete($user_id);
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}
	
	function admin_view($id = null) {
		$teacher = $this->Teacher->get($id,array(),array('User'=> array('id','username','email')));
		$title_for_layout = $teacher['User']['username'].' - szczegóły nauczyciela';
		
		$classes_id = $this->TeacherClass->find('list', array('conditions'=> array('teacher_id'=> $id),'fields'=> array('class_id','class_id')));
		$groups = $this->Group->find('all', array('contain'=> array('Classes'=> 'School'),'conditions'=> array('class_id'=> $classes_id)));
		$gradesCountPerStudent = 0;
		
		$gradesCount = $this->Grade->find('count', array('conditions'=> array('user_id'=> $teacher['User']['id'])));
		$studentsCount = 0;
		if($groups) {
			$groups_id  = Set::combine($groups, '{n}.Group.id', '{n}.Group.id');
			
			$studentsCount = $this->Profile->find('count', array(
			'recursive'=> -1,
			'contain'=> array(),
			'conditions'=> array(
				'group_id'=> $groups_id
			)));	
			
			$gradesCountPerStudent = $studentsCount?ceil(  $gradesCount / $studentsCount ):0;	
		}

		
		$this->set(compact('title_for_layout','teacher','groups','gradesCount','gradesCountPerStudent','studentsCount'));
	}

	function teacher_edit() {

	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
	}

}