<?php

class TeamsController extends LearningAppController {

	var $modelParams = array(
		'name' => 'Team',
		'contain' => array('Group'=>array('Classes'=> 'School' ) )
	);

	var $uses = array('Learning.Team', 'Learning.School', 'LearningAccount.Group');

	function __dataForEdit() {
		$this->set('groups', $this->Group->getList( $this->getClassesId() ));
	}

	function admin_index() {
		$this->set('title_for_layout', 'Lista zespołów');
		$this->NewFilter->filter($this->Team->filterData, 'Team');
		
		$this->paginate['Team']['contain'] = $this->modelParams['contain'];
		$this->paginate['Team']['order']['Team.created'] = 'DESC';
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else {
				$this->alert('Rekord nie zostal zapisany!');
			}
		} elseif ($id) {
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		} 

		if($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}
		$this->__dataForEdit();
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else {
			$this->alert('Rekord nie został usunięty!');
		}
		
		$this->redirect($this->referer());
	}

	/* TEACHER */
	function teacher_index() {
		$this->set('title_for_layout', 'Lista zespołów');
		
		$this->NewFilter->filter($this->Team->filterData, 'Team');
		$this->paginate['Team']['order']['Team.created'] = 'DESC';
		$this->paginate['Team']['contain'] = $this->modelParams['contain'];
		$this->paginate['Team']['conditions'][]['Group.class_id'] = $this->getClassesId();
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function teacher_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		}

		if($id)$this->set('title_for_layout', 'Edycja rekordu');
		else $this->set('title_for_layout', 'Dodaj rekord');

		$this->__dataForEdit();
	}

	function teacher_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else {
			$this->alert('Rekord nie został usunięty!');
		}

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
	}

}