<?php

class UnitsController extends LearningAppController {

	var $modelParams = array(
		'name' => 'Unit',
		'contain' => array('UnitPicture', 'Classes'),
		'foreign' => 'UnitPicture'
	);
	
	var $helpers = array('Text', 'Time', 'TinyMce.TinyMce');
	var $uses = array('Learning.Unit', 'Learning.Answer', 'Learning.UnitsClass', 'Learning.Classes','Learning.AnswerGrade');

	function user_download() {
		$this->view = 'media';
		$file_id = $this->Config->getParam('file_id', true);
		$unit = $this->Unit->get($file_id);
		$this->checkUnit($unit);

		$extension = 'pdf';
		$params = array(
			'id' => $unit['Unit']['pdf'],
			'name' => slug( $unit['Unit']['pdf'] ),
			'download' => true,
			'extension' => 'pdf',
			'path' => 'webroot/uploaded/unit/pdf/',
		);

		$this->set($params);
	}

	function user_index() {
		$conditions = ($this->Auth->user('admin') || $this->Auth->user('teacher') ) ? array() :array('or'=>array('publish_date IS NULL', 'publish_date <= ' => date('Y-m-d H:i:s') ));

		$units_id = $this->UnitsClass->find('list', array('fields'=>array('unit_id','unit_id'),'conditions'=> array('class_id'=> $this->getClassesId() ) ));
		$records = $this->Unit->find('all', array('conditions'=> array('id'=>$units_id )+$conditions));
		$this->set('records', $records);
		$this->set('title_for_layout', 'Zajęcia');
	}

	function user_view() {
		$id = $this->Config->getParam('id', 'Niepoprawny parametr (#ID)');

		$conditions = ($this->Auth->user('admin') || $this->Auth->user('teacher') ) ? array() :array('or'=>array('publish_date IS NULL', 'publish_date <= ' => date('Y-m-d H:i:s') ));

		$units_id = $this->UnitsClass->find('list', array('fields'=>array('unit_id','unit_id'),'conditions'=> array('class_id'=> $this->getClassesId() ) ));
		if($this->Auth->user('admin')==0 && !in_array($id,$units_id)) $this->alert('Brak dostępu #2239', '/');
		$record = $this->{ $this->modelParams['name'] }->find('first', array('conditions'=> array('id'=> $id ) + $conditions) );

		$this->checkUnit( $record );

		$pdf = $this->{ $this->modelParams['name'] }->field('pdf', array('id' => $id));
		$pictures = $this->{ $this->modelParams['name'] }->UnitPicture->find('all', array('conditions' => array('foreign_id' => $id), 'order' => 'position DESC'));
		$youtube = $this->Unit->parseYoutube( $record['Unit']['youtube'] );
		$answer = $this->Answer->get( array('Answer.user_id'=>$this->Auth->user('id'), 'Answer.unit_id'=>$id  ), array(), array('AnswerPicture') );
		$answerGrade = $this->AnswerGrade->find('first',array('contain'=>array('User'),'conditions'=> array('unit_id'=> $id, 'author_id'=> $this->Auth->user('id') )));
		$canAnswer = $this->Unit->canAnswer( $record );
		$this->set(compact('record','youtube','answer','canAnswer','pictures', 'pdf','answerGrade'));
		$this->set('title_for_layout', $record[$this->modelParams['name']]['name']);
	}

	function teacher_index() {
		$this->set('title_for_layout', 'Lista zajęć');

		$units_id = $this->UnitsClass->find('list', array('fields'=>array('unit_id','unit_id'),'conditions'=> array('class_id'=> $this->getClassesId() ) ));
		
		$this->NewFilter->filter($this->Unit->filterData, 'Unit');
		$this->paginate['Unit']['conditions'][] = array('id'=>$units_id );
				
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function teacher_edit($id = null) {
		if(!$id) $this->alert('Brak numeru ID', $this->referer());

		$record = $this->Unit->get($id);

		if (!empty($this->data)) {
			if (	isset($this->data[$this->modelParams['foreign']][0]['file']['tmp_name'])
				&& empty($this->data[$this->modelParams['foreign']][0]['file']['tmp_name'])
				)
				unset($this->data[$this->modelParams['foreign']]);

			if ($this->{ $this->modelParams['name'] }->saveAll($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else {
				$this->alert('Rekord nie został zapisany!');
			}
		} elseif ($id) {
			$this->set('title_for_layout', $record['Unit']['name']);
			$this->data = $this->{ $this->modelParams['name'] }->get($id, array(), $this->modelParams['contain']);
		}

		if ($id) {
			$pdf = $this->{ $this->modelParams['name'] }->field('pdf', array('id' => $id));
			$pictures = $this->{ $this->modelParams['name'] }->UnitPicture->find('all', array('conditions' => array('foreign_id' => $id), 'order' => 'position DESC'));
			$this->set(compact('pictures', 'pdf'));
		}

		$this->set('classes', $this->Classes->getList($this->getClassesId()));
	}
	
	function admin_index() {
		$this->NewFilter->filter($this->Unit->filterData, 'Unit');
		$this->set('title_for_layout', 'Lista zajęć');
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if (	isset($this->data[$this->modelParams['foreign']][0]['file']['tmp_name'])
				&& empty($this->data[$this->modelParams['foreign']][0]['file']['tmp_name'])
				)
				unset($this->data[$this->modelParams['foreign']]);

			if ($this->{ $this->modelParams['name'] }->saveAll($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else {
				$this->alert('Rekord nie został zapisany!');
			}
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id, array(), $this->modelParams['contain']);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}

		if ($id) {
			$pdf = $this->{ $this->modelParams['name'] }->field('pdf', array('id' => $id));
			$pictures = $this->{ $this->modelParams['name'] }->UnitPicture->find('all', array('conditions' => array('foreign_id' => $id), 'order' => 'position DESC'));
			$this->set(compact('pictures', 'pdf'));
		}

		$this->set('classes', $this->Classes->getList($this->getClassesId()));
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('pictureFolder', $this->{ $this->modelParams['name'] }->UnitPicture->storeFolder());
		$this->set('modelParams', $this->modelParams);
	}

}