<?php

class Answer extends LearningAppModel {
	var $name= 'Answer';
	var $useTable = 'learning_answers';
	var $belongsTo = array(
		'User'=>array(
			'className'=>'Account.User',
			'foreignKey'=>'user_id'
		),
		'Unit'=>array(
			'className'=> 'Learning.Unit',
			'foreignKey'=> 'unit_id',
			'counterCache'=> 'answers_count'
	));
	
	var $filterData = array(
		'basic'=> array(

			'username'=> array('type'=> 'like','model'=> 'User'),
			'unit_name'=> array('type'=> 'like', 'model'=>'Unit','field'=> 'name'),
			'grade'=> array('type'=> 'equal','options'=> array(0,1,2,3,4,5,6,7,8,9,10),'model'=> 'AnswerGrade','field'=> 'grade'),
			'body'=> array('type'=> 'like'),
			'created'=> array('type'=> 'date_between'),	
		)

	);

	var $validate = array(
		'body'=> array('rule'=>'notEmpty', 'message'=>'Pole nie może być puste!'),
	);
	
	var $hasMany = array('AnswerPicture'=> array(
		'className'=>'Learning.AnswerPicture',
		'foreignKey'=> 'answer_id',
		'dependent'=> true
	));

	var $hasOne = array('AnswerGrade'=> array('className'=>'Learning.AnswerGrade', 'foreignKey'=>'answer_id'));

}