<?php

class AnswerGrade extends LearningAppModel {
	var $name = 'AnswerGrade';
	var $useTable = 'learning_answer_grades';

	var $belongsTo = array(
		'Answer'=> array('className'=> 'Learning.Answer', 'foreignKey'=> 'answer_id', 'counterCache'=>'accepted'),
		'User'=> array('className'=> 'Account.User', 'foreignKey'=> 'user_id'),
		'Unit'=> array('className'=> 'Learning.Unit', 'foreignKey'=> 'unit_id')
		);
	var $validate = array(
		'grade'		=> array(
			array('message'=> 'Wprowadź wartość liczbową', 'rule'=> 'numeric'),
			array('message'=> 'Wprowadź punkty', 'rule'=> 'notEmpty')
		),
	);

	function saveForTeam($data, $unit_id, $team_id){

		$user_id = $_SESSION['Auth']['User']['id'];
		foreach ($data['AnswerGrade'] as $key => $row) {
			$data['AnswerGrade'][$key]['unit_id'] = $unit_id;
			$data['AnswerGrade'][$key]['user_id'] = $user_id;
		}

		return $this->saveAll($data['AnswerGrade']);
	}

	function findSum($user_id){
		$results = $this->query("SELECT SUM(grade) as 'sum' FROM {$this->useTable} WHERE author_id = $user_id");
		$sum = isset($results[0][0]['sum'])?$results[0][0]['sum']:0;
		return $sum;
	}
}