<?php

class Classes extends LearningAppModel {

	var $name = 'Classes';
	
	var $filterData = array(
		'basic'=> array(

			'name'=> array('type'=> 'like'),
			'school'=> array('type'=> 'like', 'model'=>'School','field'=> 'name'),
			'created'=> array('type'=> 'date_between'),	
		)

	);
	
	var $useTable = 'learning_classes';
	
	var $validate = array(
		'school_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'name' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	
	var $belongsTo = array(
		'School' => array(
			'className' => 'Learning.School',
			'foreignKey' => 'school_id'
		)
	);
	
	var $hasMany = array(
		'Group' => array(
			'className' => 'LearningAccount.Group',
			'foreignKey' => 'class_id',
			'dependent' => true
		));

	function getList($classes_ids) {
		return Set::combine($this->find('all', array('contain' => 'School', 'conditions' => array('Classes.id' => $classes_ids))), '{n}.Classes.id', array('{0} / {1}', '{n}.School.name', '{n}.Classes.name'), '{n}.School.name');
	}

}