<?php

class Grade extends LearningAppModel {
	var $name = 'Grade';

	var $useTable = 'learning_grades';

	var $validate = array(
		'name'		=> array('message'=> 'Wprowadź nazwę',	'rule'=> 'notEmpty'),
		'published'		=> array('message'=> 'Wypełnij',	'rule'=> 'notEmpty'),
		'type_id'		=> array('message'=> 'Wybierz typ',	'rule'=> 'notEmpty'),
		'grade'		=> array(
			array('message'=> 'Wprowadź wartość liczbową', 'rule'=> 'numeric'),
			array('message'=> 'Wprowadź punkty', 'rule'=> 'notEmpty')
		),
	);
	
	var $filterData = array(
		'basic'=> array(
			'name' => array('type'=>'like','class'=> 'long'),	
			'grade'=> array('type'=>'between','class'=> 'short', 'options'=> array(0,1,2,3,4,5,6,7,8,9,10)),	
			'profile_name'=> array('type'=>'like','class'=> 'short', 'model'=> 'Student', 'field'=> 'username'),	
			'group'=> array('cond'=> array('Student.id IN ( SELECT user_id FROM profiles WHERE group_id IN (SELECT id FROM learning_groups WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Group', 'field'=> 'name',),	
			'team'=> array('cond'=>array('Student.id IN ( SELECT user_id FROM profiles WHERE team_id IN (SELECT id FROM learning_teams WHERE name LIKE "%#replace#%"))'),'class'=> 'short', 'model'=> 'Team', 'field'=> 'name'),	
			'teacher_name'=> array('type'=>'like','class'=> 'short', 'model'=> 'User', 'field'=> 'username'),	
			'created'=> array('type'=>'date_between')	
		)

	);

	var $filterDataTeacher = array(
		'basic'=> array(
			'name' => array('type'=>'like','class'=> 'long'),	
			'grade'=> array('type'=>'between','class'=> 'short', 'options'=> array(0,1,2,3,4,5,6,7,8,9,10)),	
			'profile_name'=> array('type'=>'like','class'=> 'short', 'model'=> 'Student', 'field'=> 'username'),	
			'teacher_name'=> array('type'=>'like','class'=> 'short', 'model'=> 'User', 'field'=> 'username'),	
			'created'=> array('type'=>'date_between')	
		)

	);
	var $validateAdminAdd = array(
		'class_id'=> array('message'=> 'Wybierz klasę', 'rule'=> 'notEmpty'),
	);

	var $types = array(
		1=> 'Zadania domowe',
		2=> 'Testy umiejętności',
		3=> 'Praca na zajęciach'
	);

	var $belongsTo = array(
		'User'=> array( // wystawiający
			'className'=> 'Account.User',
			'foreignKey'=> 'user_id'
		),
		'Student'=> array( // uczeń
			'className'=> 'Account.User',
			'foreignKey'=> 'student_id'
		),
//		'Classes'=> array(
//			'className'=> 'Learning.Classes',
//			'foreignKey'=> 'class_id'
//		)
	);

	function customSaveAll($data){
		$save = array();
		$grade = array_shift( $data );
		$grade['user_id'] = $_SESSION['Auth']['User']['id'];
		foreach ($data as $row) {
			$save[] = $grade + $row;
		}
		return $this->saveAll($save);

	}

	function findSum($user_id){
		$results = $this->query("SELECT SUM(grade) as 'sum',type_id FROM {$this->useTable} WHERE student_id = $user_id GROUP BY type_id");
		$results = Set::combine($results, '{n}.learning_grades.type_id', '{n}.0.sum');
		$sum = array('1'=> 0, '2'=> 0, '3'=> 0);
		if(isset($results[1])) $sum['1'] += $results[1];
		if(isset($results[2])) $sum['2'] += $results[2];
		if(isset($results[3])) $sum['3'] += $results[3];
		return $sum;
	}

	function bestInSchool($user_id){
		$school_id = $this->User->Profile->field('school_id', array('user_id'=> $user_id));
		if(!$school_id) return 0;
		$best = $this->ranking($user_id, "AND p.school_id = $school_id");
		return $best;
	}

	function bestInClass($user_id){ 
		$class_id = $this->User->Profile->field('class_id', array('user_id'=> $user_id));
		if(!$class_id) return 0;
		$best = $this->ranking($user_id, "AND p.class_id = $class_id");
		return $best;
	}

	function bestInGroup($user_id){
		$group_id = $this->User->Profile->field('group_id', array('user_id'=> $user_id));
		if(!$group_id) return 0;
		$best = $this->ranking($user_id, "AND p.group_id = $group_id");
		return $best;
	}

	function bestIn($user_id){ 
		$best = $this->ranking($user_id, "");
		return $best;
	}
	
	
	function ranking($user_id, $condition) {
		$atable = 'learning_answer_grades';
		$gtable = 'learning_grades';
		$utable = 'account_users';
		$results = $this->query(
			"SELECT g.sum,u.id,u.username FROM (
				SELECT sum( grades.sum ) as 'sum', user_id
				FROM (
					SELECT sum( g.grade ) AS sum, student_id AS user_id
					FROM `$gtable` g, profiles p
					WHERE p.user_id = student_id
					$condition
					GROUP BY student_id
				UNION ALL
					SELECT sum( g.grade ) AS sum, author_id AS user_id
					FROM `$atable` g, profiles p
					WHERE p.user_id = author_id
					$condition
					GROUP BY author_id
				) grades
				GROUP BY user_id

			) g, $utable u WHERE u.id = g.user_id
			order by g.sum DESC LIMIT 3
			"
			); 
		 
		return $results;
	}

	function position($user_id, $condition){
		$atable = 'learning_answer_grades';
		$gtable = 'learning_grades';
		$utable = 'account_users';
		$profile_id = $this->User->Profile->field('id', array('user_id'=> $_SESSION['Auth']['User']['id']));
		if(!$profile_id) return array();

		$this->query('SET @rownum := 0;');
		$results = $this->query(
			"
			SELECT p.place FROM (
			SELECT @rownum := @rownum + 1 as place,u.id as 'user_id' FROM (
				SELECT sum( grades.sum ) as 'sum', user_id
				FROM (
					SELECT sum( g.grade ) AS sum, student_id AS user_id
					FROM `$gtable` g, profiles p
					WHERE p.user_id = student_id
					$condition
					GROUP BY student_id
				UNION ALL
					SELECT sum( g.grade ) AS sum, author_id AS user_id
					FROM `$atable` g, profiles p
					WHERE p.user_id = author_id
					$condition
					GROUP BY author_id
				) grades
				GROUP BY user_id

			) g, $utable u WHERE u.id = g.user_id
			order by g.sum DESC
			) p 
			WHERE user_id = $user_id
			"
		);

		return isset($results[0]['p']['place'])?$results[0]['p']['place']:0;
	}

	function classPosition($user_id){

		$class_id = $this->User->Profile->field('class_id', array('user_id'=> $user_id));

		if(!$class_id) return 0;
		$best = $this->position($user_id, "AND p.class_id = $class_id");
		
		return $best;
	}

	function schoolPosition($user_id){
		$school_id = $this->User->Profile->field('school_id', array('user_id'=> $user_id));

		if(!$school_id) return 0;
		
		$best = $this->position($user_id, "AND p.school_id = $school_id");
		return $best;
	}

	function groupPosition($user_id){

		$group_id = $this->User->Profile->field('group_id', array('user_id'=> $user_id));

		if(!$group_id) return 0;
		$best = $this->position($user_id, "AND p.group_id = $group_id");
		
		return $best;
	}

	function projectPosition($user_id){
		$best = $this->position($user_id, "");
		return $best;
	}


}