<?php

class Raport extends LearningAppModel {
	public $useTable = false;
	
	public $queries = array(

		'ilosc_ocen_nauczycieli'=> array( 
			'query'=> 'SELECT u.username as Nauczyciel, uczniow.team as Zespół, g.name as Grupa, c.name as Klasa, s.name as Szkoła, uczniow.students AS Uczniów, liczba.ocen as Ocen FROM (SELECT t.id as team_id, t.name as team, count( p.id ) as students FROM `learning_teams` t, `profiles` p WHERE p.team_id = t.id GROUP BY t.id ) as uczniow, (SELECT t.id as team_id, t.name as team, count( g.id ) as ocen FROM `learning_teams` t, `learning_grades` g, `profiles` p WHERE p.team_id = t.id AND g.student_id = p.user_id GROUP BY t.id ) as liczba, `learning_teams` t, `learning_classes` c, `learning_schools` s, `learning_groups` g, `learning_teachers_classes` tc, `learning_teachers` lt, `account_users` u WHERE tc.teacher_id = lt.id AND lt.user_id = u.id AND tc.class_id = c.id AND liczba.team_id = uczniow.team_id AND t.id = uczniow.team_id AND t.group_id = g.id AND g.class_id = c.id AND c.school_id = s.id ORDER BY u.username, s.name,c.name,g.name,t.name',
			'name'=> 'Ilość ocen nauczycieli',
			'fields'=> array('Nauczyciel' , 'Zespół' , 'Grupa' ,'Klasa' , 'Szkoła' , 'Uczniów' , 'Ocen') 
		),
		'ilosc_ocen_zespolu'=> array(
			'query'=> 'SELECT uczniow.team as Zespół, c.name as Klasa, s.name as Szkoła, uczniow.students AS Uczniów, liczba.ocen as Ocen FROM (SELECT t.id as team_id, t.name as team, count( p.id ) as students FROM `learning_teams` t, `profiles` p WHERE p.team_id = t.id GROUP BY t.id ) as uczniow, (SELECT t.id as team_id, t.name as team, count( g.id ) as ocen FROM `learning_teams` t, `learning_grades` g, `profiles` p WHERE p.team_id = t.id AND g.student_id = p.user_id GROUP BY t.id ) as liczba, `learning_teams` t, `learning_classes` c, `learning_schools` s, `learning_groups` g WHERE liczba.team_id = uczniow.team_id AND t.id = uczniow.team_id AND t.group_id = g.id AND g.class_id = c.id AND c.school_id = s.id ORDER BY s.name,c.name,g.name,t.name',
			'name'=> 'Ilość ocen w zespołach',
			'fields'=> array('Zespół','Klasa', 'Szkoła' , 'Ilość uczniów' , 'Ilość wystawionych ocen')
		),
		'srednia_ocen_uczniow'=> array(
			'query'=> 'SELECT s.id,s.username as Uczeń, avg(g.grade) as Średnia, count(g.grade) as Liczba FROM `learning_grades` g, `account_users` s WHERE g.student_id = s.id group by s.id order by s.username ASC',
			'name'=> 'Średnia ocen uczniów',
			'fields'=> array('Nr id','Nazwisko ucznia','Średnia','Liczba')
		),
		'ilosc_ocen_nauczycieli'=> array(
			'query'=> 'SELECT username as Nauczyciel, count(g.id) as liczba_ocen FROM `account_users` u, `learning_grades` g WHERE teacher = 1 AND g.user_id = u.id Group by user_id',
			'name'=> 'Ilość ocen nauczycieli',
			'fields'=> array('Nauczyciel','ilość wystawionych ocen')
		),
		'lista_nauczycieli'=> array(
			'query'=> 'SELECT username as Nauczyciel, email as Email, created as utworzono FROM `account_users` u WHERE u.teacher = 1 ',
			'name'=> 'Lista nauczycieli',
			'fields'=> array('Nauczyciel','email', 'utworzono')
		),
		'lista_uczniow'=> array(
			'query'=> 'SELECT u.username as Uczen, u.email as Email, u.created as utworzono, t.name, g.name, c.name, s.name as Szkoła FROM `account_users` u, `learning_schools` s, learning_groups g, learning_classes c, learning_teams t, profiles p WHERE u.teacher = 0 AND u.admin = 0 AND p.user_id = u.id AND s.id = p.school_id AND t.id = p.team_id AND c.id = p.class_id AND g.id = p.group_id',
			'name'=> 'Lista zarejestrowanych uczniów',
			'fields'=> array('Uczeń','email', 'utworzono', 'zespół','grupa','klasa', 'szkoła')
		),			
		'klasy_w_szkole' => array(
			'query'=> 'SELECT s.name, t.name, g.name , c.name FROM learning_schools s, learning_groups g, learning_classes c, learning_teams t WHERE s.id = c.school_id AND c.id = g.class_id AND g.id = t.group_id AND school_id = "#school_id#" ',
			'vars'=> array('school_id'),
			'listHide'=> true,
			'fields'=> array('szkoła','zespół','grupa','klasa')			
		),
		'srednia_w_szkole'=> array(
			'query'=> 'SELECT uczniow.team as Zespół, c.name as Klasa, s.name as Szkoła, uczniow.students AS Uczniów, liczba.ocen as Srednia FROM (SELECT t.id as team_id, t.name as team, count( p.id ) as students FROM `learning_teams` t, `profiles` p WHERE p.team_id = t.id GROUP BY t.id ) as uczniow, (SELECT t.id as team_id, t.name as team, avg( g.grade ) as ocen FROM `learning_teams` t, `learning_grades` g, `profiles` p WHERE p.team_id = t.id AND g.student_id = p.user_id GROUP BY t.id ) as liczba, `learning_teams` t, `learning_classes` c, `learning_schools` s, `learning_groups` g WHERE liczba.team_id = uczniow.team_id AND t.id = uczniow.team_id AND t.group_id = g.id AND g.class_id = c.id AND c.school_id = s.id AND s.id = "#school_id#"  ORDER BY liczba.ocen DESC, s.name,c.name,g.name,t.name',
			'vars'=> array('school_id'),
			'listHide'=> true,
			'fields'=> array( 'Zespół' , 'Ilość uczniów','Klasa' , 'Szkoła'  , 'Średnia wystawionych ocen')		
		),
		'srednia_ucznia'=> array(
			'query'=> 'SELECT s.username, avg(g.grade) as grade, count(g.grade),  school.name FROM `learning_grades` g, profiles p, account_users s, learning_schools school WHERE p.user_id = s.id AND g.student_id = s.id AND school.id = p.school_id AND school.id = "#school_id#"  GROUP BY s.id ORDER BY grade DESC',
			'vars'=> array('school_id'),
			'listHide'=> true,
			'fields'=> array( 'Nazwisko ucznia' , 'Średnia ocen', 'Ilość ocen', 'Szkoła')
		),
		'ilosc_ocen_nauczyciela'=> array(
			'query'=> 'SELECT u.username as Nauczyciel, uczniow.team as Zespół, g.name as Grupa, c.name as Klasa, s.name as Szkoła, uczniow.students AS Uczniów, liczba.ocen as Ocen FROM (SELECT t.id as team_id, t.name as team, count( p.id ) as students FROM `learning_teams` t, `profiles` p WHERE p.team_id = t.id GROUP BY t.id ) as uczniow, (SELECT t.id as team_id, t.name as team, count( g.id ) as ocen FROM `learning_teams` t, `learning_grades` g, `profiles` p WHERE p.team_id = t.id AND g.student_id = p.user_id GROUP BY t.id ) as liczba, `learning_teams` t, `learning_classes` c, `learning_schools` s, `learning_groups` g, `learning_teachers_classes` tc, `learning_teachers` lt, `account_users` u WHERE tc.teacher_id = lt.id AND lt.user_id = u.id AND tc.class_id = c.id AND liczba.team_id = uczniow.team_id AND t.id = uczniow.team_id AND t.group_id = g.id AND g.class_id = c.id AND c.school_id = s.id AND s.id = "#school_id#" ORDER BY u.username, s.name,c.name,g.name,t.name',
			'vars'=> array('school_id'),
			'listHide'=> true,
			'fields'=> array('Nauczyciel', 'Zespół','Uczniów','Grupa','Klasa','Szkoła', 'Ocen')
		)
	);
	public function getList(){
		foreach ($this->queries as $alias => $query ) {
			if(!empty($query['listHide'])){
				unset($this->queries[$alias]);
			}
		}
		
		return $this->queries;
	}

	
	public function getData($alias = null, $vars = false){

		$query = $this->getQuery($alias, $vars);

		$data = $this->query($query['query']);

		if(!$data) {
			return false;
		}
					
		foreach ($data as $key => $value) {
			$data[$key] = array_combine($query['fields'], Set::flatten($value));
		}
				
		return $data;
	}
	
	public function getQuery($alias, $vars = false) {
		if(!$alias || !isset($this->queries[$alias])) {
			return null;
		}
		
		$query = $this->queries[$alias];
		
		if($vars) {
			$tags = array();
			foreach ($vars as $key=> $var) {
				$tags["#$key#"] = $var;
			}
			$query['query'] = str_replace(array_keys($tags),array_values($tags), $query['query']);
		}
							
		return $query;
	}
	public function getCSV($alias, $vars) {
		$data = $this->getData($alias, $vars);

		if(!$data) {
			return false;
		}
		
		$query = $this->getQuery($alias, $vars);
		
		$csv = $this->putCSVline($query['fields']);
		
		foreach ($data as $values) {
			$csv .= $this->putCSVline($values);
		}
		
		$filename = $this->getFilename($alias, $vars);
		
		$return = array('csv'=> $csv,'filename'=> $filename);
		
		return $return;
	}
	
	public function getFilename($alias, $vars){
		$add = null;
		foreach ($vars as $var) {
			$add .= ('_'.$var);
		}
		
		return $alias.$add.'-'.date('Y_m_d__H_i').'.csv';
	}
	
	public function putCSVLine($data){
		$outstream = fopen("php://temp", 'r+');
        fputcsv($outstream, $data, ',', '"');
        rewind($outstream);
        $csv = fgets($outstream);
        fclose($outstream);
        return $csv;		
	}

}