<?php

class School extends LearningAppModel {

	var $name = 'School';
	var $useTable = 'learning_schools';
	var $validate = array(
		'name' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	
	var $filterData = array(
		'basic'=> array(
			'avatar'=> null,
			'name'=> array('type'=> 'like'),
			'created'=> array('type'=> 'date_between'),	
		)

	);
		
	
	var $hasMany = array(
		'Classes' => array(
			'className' => 'Learning.Classes',
			'foreignKey' => 'school_id',
			'dependent' => true
		)
	);
	var $actsAs = array(
		'Upload' => array(
			'avatar' => array(
				'dir' => 'uploaded{DS}{ModelName}{DS}{fieldName}',
				'create_directory' => true,
				'allowedMime' => false,
				'allowedExt' => array('.jpg', '.jpeg', '.png', '.gif'),
				'filesize' => 'filesize',
				'mimetype' => 'url_mimetype',
				'thumbsizes' => array(
					'small' => array('width' => 85, 'height' => 85, 'zoomCrop' => 'C', 'zc' => 'C', 'zoom_crop' => 'C'),
				),
				'imageMagickPath' => false
		)));

}