<?php

class Teacher extends LearningAppModel {

	var $name = 'Teacher';
	
	var $useTable = 'learning_teachers';
	
	var $validate = array(
		'name' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);

	var $filterData = array(
		'basic'=> array(
			'name'=> array('type'=> 'like','model'=> 'User','field'=> 'username'),
			'email'=> array('type'=> 'like','model'=> 'User'),
			'created'=> array('type'=> 'date_between'),
			
		)

	);	
	
	var $belongsTo = array('User' => array('className' => 'Account.User'));
	
	var $hasAndBelongsToMany = array(
		'Classes' =>
		array(
			'className' => 'Learning.Classes',
			'joinTable' => 'learning_teachers_classes',
			'foreignKey' => 'teacher_id',
			'associationForeignKey' => 'class_id',
			'fields' => array('id')
			));

}