<?php

class Team extends LearningAppModel {
	var $name = 'Team';
	var $useTable = 'learning_teams';
	var $belongsTo = array(
		'Group'=> array(
			'className'=> 'LearningAccount.Group',
			'foreignKey'=> 'group_id'
		)
	);
	var $validate = array(
		'group_id' => array(
			'rule' => 'notEmpty',
			'message' => 'Pole nie może być puste'
		),
		'name' => array(
			'rule' => 'notEmpty',
			'message' => 'Pole nie może być puste'
		)
	);

	function getList($classes_ids) {
		$teams = $this->find('all', array(
			'contain' => array( 'Group'=>array('Classes'=> 'School') ),
			'conditions'=> array('Group.class_id'=> $classes_ids) )
		);
		return Set::combine($teams,
			'{n}.Team.id',
			array(
				'<b>{0}</b> ( {1} / {2} / {3} )',
				'{n}.Team.name',
				'{n}.Group.Classes.School.name',
				'{n}.Group.Classes.name',
				'{n}.Group.name'
				
			)
		);
	}
	
	var $filterData = array(
		'basic'=> array(

			'name'=> array('type'=> 'like'),
			'group'=> array('type'=> 'like', 'model'=>'Group','field'=> 'name'),		
			'class'=> array('cond'=> array('Team.id IN ( SELECT id FROM learning_teams WHERE group_id IN (SELECT id FROM learning_groups WHERE class_id IN (SELECT id FROM learning_classes WHERE name LIKE "%#replace#%")) )'), 'model'=>'Class','field'=> 'name'),
			'school'=> array('cond'=> array('Team.id IN ( SELECT id FROM learning_teams WHERE group_id IN (SELECT id FROM learning_groups WHERE class_id IN (SELECT id FROM learning_classes WHERE school_id IN (SELECT id FROM learning_schools WHERE name LIKE "%#replace#%")) ))'), 'model'=>'School','field'=> 'name'),
			'created'=> array('type'=> 'date_between'),	
		)

	);		

}