<?php

class Unit extends LearningAppModel {

	var $name = 'Unit';
	var $useTable = 'learning_units';
	var $validate = array(
		'name' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
	);
	
	
	var $actsAs = array(
		'Move',
		'Upload' => array(
			'pdf' => array(
				'dir' => 'uploaded{DS}{ModelName}{DS}{fieldName}',
				'create_directory' => true,
				'allowedMime' => false,
				'allowedExt' => array('pdf'),
				'filesize' => 'filesize',
				'mimetype' => 'mimetype',
				'imageMagickPath' => false
	)));
	
	var $filterData = array(
		'basic'=> array(
			'name'=> array('type'=> 'like'),
			'publish_date'=> array('type'=> 'date_between'),
			'end'=> null,
			'answers_count'=> array('type'=> 'between'),
		)

	);	
	
	var $hasMany = array(
		'UnitPicture' => array(
			'className' => 'Learning.UnitPicture',
			'foreignKey' => 'foreign_id',
			'dependent'=> true
		),
		'Answer'=> array(
			'className'=> 'Learning.Answer',
			'foreignKey'=> 'unit_id',
			'dependent'=> true
		),
		'AnswerGrade'=> array(
			'className'=> 'Learning.AnswerGrade',
			'foreignKey'=> 'unit_id',
			'dependent'=> true
		)
	);
	var $hasAndBelongsToMany = array(
		'Classes' =>
		array(
			'className'	=> 'Learning.Classes',
			'joinTable'	=> 'learning_units_classes',
			'foreignKey'	=> 'unit_id',
			'associationForeignKey' => 'class_id',
			'fields' => array('id')
		));
	
	function canAnswer($unit){
		
		$user_id = $_SESSION['Auth']['User']['id'];
		$user = $_SESSION['Auth']['User'];
		if($user['admin'] || $user['teacher']) return false;
		$accepted = $this->Answer->field('accepted', array('user_id'=> $user_id));
		if($accepted) return false;
		
		if(!$unit['Unit']['end']) return true;

		if(strtotime($unit['Unit']['end']) <= time()) return false;
		return true;
	}

	/**
	 * Funkcja zwraca ID filmu z podanego linka.
	 * @param <type> $link Youtube link
	 */
	function parseYoutube($link = null){
		preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=[0-9]/)[^&\n]+|(?<=v=)[^&\n]+#", $link, $matches);
		return end($matches);
	}

	function beforeSave(){
		parent::beforeSave();
		if(isset($this->data['Unit']['end']) && empty($this->data['Unit']['end'])) $this->data['Unit']['end'] = null;
		if(isset($this->data['Unit']['publish_date']) && empty($this->data['Unit']['publish_date'])) $this->data['Unit']['publish_date'] = null;
		return true;
	}
}