<?php

class UnitPicture extends LearningAppModel {

	var $name = 'UnitPicture';
	var $useTable = 'learning_unit_pictures';
	var $belongsTo = array(
		'Unit' => array('className' => 'Learning.Unit', 'foreignKey' => 'foreign_id')
	);
	var $validate = array(
		'title' => array('message' => 'Pole nie może być puste', 'rule' => 'notEmpty')
	);
	var $actsAs = array(
		'Move' => array('group' => 'foreign_id'),
		'Upload' => array(
			'file' => array(
				'dir' => 'uploaded{DS}{ModelName}{DS}{fieldName}',
				'create_directory' => true,
				'allowedMime' => false,
				'allowedExt' => array('.jpg', '.jpeg', '.png', '.gif'),
				'filesize' => 'filesize',
				'mimetype' => 'url_mimetype',
				'thumbsizes' => array(
					'small' => array('width' => 210, 'height' => 115),
					'medium' => array('width' => 210, 'height' => 210),
					'large' => array('width' => 800, 'height' => 600)
				),
				'imageMagickPath' => false
		)));

}