<?php
/**
 * Zapisuje i odczytuje opcje paginacji i formularza w sesji
 * przykład użycia:
		//ustawienie domyślnej paginacji
		$default = array(
			'limit' => 20,
			'order' => array('PubCategoriesPublication.position' => 'desc'),
			'conditions' => "PubCategoriesPublication.pub_category_id = '".key($categories)."'",
			'contain' => array('Publication'),
			'fields' => array('PubCategoriesPublication.id', 'Publication.id', 'Publication.title', 'Publication.created', 'Publication.image')
		);
		$this->SavePaginate->setPaginateOptions($default);
		//przyjecie danych z formularza ustawiając paginację
		if(!empty($this->data['Filter']['category_id'])){
			$this->paginate['conditions'] = "Article.category_id = '{$this->data['Filter']['category_id']}'";
		}
		if(!empty($this->data['Filter']['limit'])){
			$this->paginate['limit'] = $this->data['Filter']['limit'];
		}
		$articles = $this->SavePaginate->paginate('Article');
		//zapisanie lub odczytanie formularza z sesji
		$this->SavePaginate->saveSetForm('Filter', array('limit' => 20));
 */

class SavePaginateComponent extends Object {
	var $components = array("Session");

	var $defaultPaginate = array();

	function initialize(&$controller) {
		$this->controller = &$controller;
	}

  	/**
 	* Automatyczna paginacja rekordów modelu razem z zapisaniem/odczytaniem opcji paginacji w sesji
 	*
 	* @param string $object Model name to paginate (e.g: 'Model', or 'Model.InnerModel')
 	* @param mixed $scope Conditions to use while paginating
 	* @param array $whitelist List of allowed options for paging
 	* @return array Model query results
 	* @access public
 	*/
	function paginate($object = null, $scope = array(), $whitelist = array()){
		$result = $this->controller->paginate($object, $scope, $whitelist);
		$this->__savePaginateOptions($object);
		$this->setResetLink();
		return $result;
	}

	function setResetLink(){
		if(!empty($this->controller->params['named']['sort']) && !empty($this->controller->params['named']['direction'])){
			$this->controller->paginate['order'][$this->controller->params['named']['sort']] = $this->controller->params['named']['direction'];
		}
		if(!isSet($this->defaultPaginate['order']))$this->defaultPaginate['order'] = array();
		if(!isSet($this->controller->paginate['order']))$this->controller->paginate['order'] = array();
		if(!isSet($this->defaultPaginate['conditions']))$this->defaultPaginate['conditions'] = array();
		if(!isSet($this->controller->paginate['conditions']))$this->controller->paginate['conditions'] = array();
		if($this->defaultPaginate['order'] != $this->controller->paginate['order'] || $this->defaultPaginate['conditions'] != $this->controller->paginate['conditions']){
			$this->controller->set('resetPagination', true);
		}
	}

	function resetPagination($formName = null){
		if(!$formName)
			$formName = 'Filter';
		if(!empty($this->controller->params['named']['reset'])){
			$paginateTempName = 'tmp.paginate.'.$this->controller->plugin.'-'.$this->controller->name.'-'.$this->controller->action;
			$this->Session->del($paginateTempName);
			$sessionFormPath = 'tmp.savedForms.'.$this->controller->plugin.'-'.$this->controller->name.'-'.$this->controller->action.'-'.$formName;
			$this->Session->del($sessionFormPath);
		}
	}

	function setPaginateOptions($default = array()){
		$paginateTempName = 'tmp.paginate.'.$this->controller->plugin.'-'.$this->controller->name.'-'.$this->controller->action;
		$this->defaultPaginate = $default;
		if($this->Session->check($paginateTempName)){
			$this->controller->paginate = $this->Session->read($paginateTempName);
		}
		else{
			$this->controller->paginate = $default;
		}
	}

	function __savePaginateOptions($model){
		$paginateTempName = 'tmp.paginate.'.$this->controller->plugin.'-'.$this->controller->name.'-'.$this->controller->action;
		$this->Session->write($paginateTempName, $this->controller->params['paging'][$model]['options']);
	}

  	/**
 	* zapis/odczyt danych formularza w sesji
 	*
 	* @param string $formName Nazwa formularza np. Filter
 	* @param array $default domyślne ustawienia formularza np. array('Filter', 20)
 	* @access public
 	*/
	function saveSetForm($formName = null, $default){
		if(!$formName)
			$formName = 'Filter';
		$sessionFormPath = 'tmp.savedForms.'.$this->controller->plugin.'-'.$this->controller->name.'-'.$this->controller->action.'-'.$formName;
		if(!empty($this->controller->data[$formName])){
			$this->Session->write($sessionFormPath, $this->controller->data[$formName]);
		}
		else if($this->Session->check($sessionFormPath)){
			$this->controller->data[$formName] = $this->Session->read($sessionFormPath);
		}
		else{
			$this->controller->data[$formName] = $default;
		}
	}

}
?>